/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class BitstreamMatcher {
    private BitstreamMatcher() {
    }

    public static Matcher<? super Object> matchBitstreamEntry(Bitstream bitstream) {
        return Matchers.allOf(BitstreamMatcher.matchProperties(bitstream), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.checkSum", BitstreamMatcher.matchChecksum()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.format", BitstreamMatcher.matchFormat()), BitstreamMatcher.matchLinks(bitstream.getID()));
    }

    public static Matcher<? super Object> matchBitstreamEntry(UUID uuid, long size, String name, String description) {
        return Matchers.allOf(BitstreamMatcher.matchProperties(uuid, size, name, description), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.checkSum", BitstreamMatcher.matchChecksum()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.format", BitstreamMatcher.matchFormat()), BitstreamMatcher.matchLinks(uuid));
    }

    public static Matcher<? super Object> matchBitstreamEntry(UUID uuid, long size) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sizeBytes", (Matcher)Matchers.is((Object)((int)size))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.checkSum", BitstreamMatcher.matchChecksum()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.format", BitstreamMatcher.matchFormat()), BitstreamMatcher.matchLinks(uuid));
    }

    public static Matcher<? super Object> matchBitstreamEntryWithoutEmbed(UUID uuid, long size) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sizeBytes", (Matcher)Matchers.is((Object)((int)size))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.checkSum", BitstreamMatcher.matchChecksum()), BitstreamMatcher.matchLinks(uuid));
    }

    private static Matcher<? super Object> matchChecksum() {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.checkSumAlgorithm", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.not((Matcher)Matchers.empty())));
    }

    private static Matcher<? super Object> matchFormat() {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.mimetype", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstreamformat")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())));
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("bundle", "format");
    }

    public static Matcher<? super Object> matchLinks(UUID uuid) {
        return HalMatcher.matchLinks("http://localhost/api/core/bitstreams/" + uuid, "bundle", "content", "format", "self");
    }

    public static Matcher<? super Object> matchProperties(Bitstream bitstream) {
        try {
            return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)bitstream.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)bitstream.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.bundleName", (Matcher)Matchers.is((Object)((Bundle)bitstream.getBundles().get(0)).getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.title", bitstream.getName()), MetadataMatcher.matchMetadata("dc.description", bitstream.getDescription()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sizeBytes", (Matcher)Matchers.is((Object)((int)bitstream.getSizeBytes()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.checkSum", BitstreamMatcher.matchChecksum()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Matcher<? super Object> matchProperties(UUID uuid, long size, String name, String description) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.title", name), MetadataMatcher.matchMetadata("dc.description", description))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sizeBytes", (Matcher)Matchers.is((Object)((int)size))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.checkSum", BitstreamMatcher.matchChecksum()));
    }
}

