/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class CommunityMatcher {
    private CommunityMatcher() {
    }

    public static Matcher<? super Object> matchCommunityEntry(UUID uuid, String handle) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)handle)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"community")), CommunityMatcher.matchLinks(uuid));
    }

    public static Matcher<? super Object> matchCommunityEntryMultipleTitles(List<String> titles, UUID uuid, String handle) {
        return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)titles.get(0))), JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)handle)), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"community")), JsonPathMatchers.hasJsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty())), CommunityMatcher.matchLinks(uuid)});
    }

    public static Matcher<? super Object> matchCommunityEntry(String name, UUID uuid, String handle) {
        return Matchers.allOf(CommunityMatcher.matchProperties(name, uuid, handle), CommunityMatcher.matchLinks(uuid));
    }

    public static Matcher<? super Object> matchCommunityEntryNonAdminEmbeds(String name, UUID uuid, String handle) {
        return Matchers.allOf(CommunityMatcher.matchProperties(name, uuid, handle), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty())), CommunityMatcher.matchLinks(uuid), CommunityMatcher.matchNonAdminEmbeds());
    }

    public static Matcher<? super Object> matchCommunityEntryFullProjection(String name, UUID uuid, String handle) {
        return Matchers.allOf(CommunityMatcher.matchProperties(name, uuid, handle), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty())), CommunityMatcher.matchLinks(uuid), CommunityMatcher.matchFullEmbeds());
    }

    public static Matcher<? super Object> matchProperties(String name, UUID uuid, String handle) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)handle)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"community")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", name)})));
    }

    public static Matcher<? super Object> matchNonAdminEmbeds() {
        return HalMatcher.matchEmbeds("collections[]", "logo", "parentCommunity", "subcommunities[]");
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("collections[]", "logo", "parentCommunity", "subcommunities[]", "adminGroup");
    }

    public static Matcher<? super Object> matchLinks(UUID uuid) {
        return HalMatcher.matchLinks("http://localhost/api/core/communities/" + uuid, "collections", "logo", "self", "parentCommunity", "subcommunities", "adminGroup");
    }

    public static Matcher<? super Object> matchCommunityWithCollectionEntry(String name, UUID uuid, String handle, Collection col) {
        return Matchers.allOf(CommunityMatcher.matchProperties(name, uuid, handle), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.collections._embedded.collections[0]", CollectionMatcher.matchCollectionEntry(col.getName(), col.getID(), col.getHandle(), col.getLogo())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty())), CommunityMatcher.matchLinks(uuid));
    }

    public static String getNonAdminEmbeds() {
        return "collections,logo,parentCommunity,subcommunities";
    }

    public static Matcher<? super Object> matchCommunity(Community community) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)community.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)community.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"community")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)community.getHandle())));
    }
}

