/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class HalMatcher {
    private HalMatcher() {
    }

    public static Matcher<? super Object> matchNoEmbeds() {
        return JsonPathMatchers.hasNoJsonPath((String)"$._embedded");
    }

    public static Matcher<? super Object> matchEmbeds(String ... rels) {
        if (rels.length == 0) {
            return HalMatcher.matchNoEmbeds();
        }
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String rel : rels) {
            if (rel.endsWith("[]")) {
                rel = rel.replace("[]", "");
                matchers.add(JsonPathMatchers.hasJsonPath((String)("$._embedded." + rel + "._embedded." + rel)));
                continue;
            }
            matchers.add(JsonPathMatchers.hasJsonPath((String)("$._embedded." + rel)));
        }
        matchers.add(JsonPathMatchers.hasJsonPath((String)"$._embedded.length()", (Matcher)Matchers.equalTo((Object)rels.length)));
        return Matchers.allOf(matchers);
    }

    public static Matcher<? super Object> matchLinks(String selfHref, String ... rels) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String rel : rels) {
            String href = rel.equals("self") ? selfHref : selfHref + "/" + rel;
            matchers.add(JsonPathMatchers.hasJsonPath((String)("$._links." + rel + ".href"), (Matcher)Matchers.is((Object)href)));
        }
        matchers.add(JsonPathMatchers.hasJsonPath((String)"$._links.length()", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(rels.length))));
        return Matchers.allOf(matchers);
    }
}

