/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.RelationshipTypeMatcher;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RelationshipMatcher {
    private RelationshipMatcher() {
    }

    public static Matcher<? super Object> matchRelationship(Relationship relationship) {
        return RelationshipMatcher.matchRelationshipExplicitValues(relationship.getLeftItem(), relationship.getRightItem(), relationship.getLeftPlace(), relationship.getRightPlace(), relationship.getRelationshipType());
    }

    private static Matcher<? super Object> matchRelationshipExplicitValues(Item leftItem, Item rightItem, int leftPlace, int rightPlace, RelationshipType relationshipType) {
        return RelationshipMatcher.matchRelationshipExplicitObjectValues(leftItem.getID(), rightItem.getID(), leftPlace, rightPlace, relationshipType);
    }

    private static Matcher<? super Object> matchRelationshipExplicitObjectValues(UUID leftId, UUID rightId, int leftPlace, int rightPlace, RelationshipType relationshipType) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.leftItem.href", (Matcher)Matchers.containsString((String)leftId.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)rightId.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)leftPlace)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.rightPlace", (Matcher)Matchers.is((Object)rightPlace)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.relationshipType", RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType)));
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("relationshipType");
    }
}

