/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.content.WorkspaceItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class WorkspaceItemMatcher {
    private WorkspaceItemMatcher() {
    }

    public static Matcher matchItemWithTitleAndDateIssued(WorkspaceItem witem, String title, String dateIssued) {
        return Matchers.allOf(WorkspaceItemMatcher.matchProperties(witem), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)title)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)dateIssued)), WorkspaceItemMatcher.matchLinks(witem));
    }

    public static Matcher matchItemWithTitleAndDateIssuedAndSubject(WorkspaceItem witem, String title, String dateIssued, String subject) {
        return Matchers.allOf(WorkspaceItemMatcher.matchProperties(witem), (Matcher)(title != null ? JsonPathMatchers.hasJsonPath((String)"$.sections.traditionalpageone['dc.title'][0].value", (Matcher)Matchers.is((Object)title)) : JsonPathMatchers.hasNoJsonPath((String)"$.sections.traditionalpageone['dc.title']")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sections.traditionalpageone['dc.date.issued'][0].value", (Matcher)Matchers.is((Object)dateIssued)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.sections.traditionalpagetwo['dc.subject'][0].value", (Matcher)Matchers.is((Object)subject)), WorkspaceItemMatcher.matchLinks(witem));
    }

    public static Matcher<? super Object> matchProperties(WorkspaceItem witem) {
        if (witem != null) {
            return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)witem.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"workspaceitem")));
        }
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"workspaceitem")));
    }

    public static Matcher<? super Object> matchLinks(WorkspaceItem witem) {
        if (witem != null) {
            return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.is((Object)("http://localhost/api/submission/workspaceitems/" + witem.getID()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.item.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.collection.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.submitter.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.submissionDefinition.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")));
        }
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.item.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.collection.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.submitter.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.submissionDefinition.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")));
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("collection", "item", "submitter", "submissionDefinition");
    }
}

