/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.util.List;
import java.util.stream.Collectors;
import org.dspace.app.rest.security.EPersonRestAuthenticationProvider;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EPersonRestAuthenticationProviderTest {
    @InjectMocks
    private EPersonRestAuthenticationProvider ePersonRestAuthenticationProvider;
    @Mock
    private EPerson ePerson;
    @Mock
    private Context context;
    @Mock
    private AuthorizeService authorizeService;

    @Test
    public void testGetGrantedAuthoritiesAdmin() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context, this.ePerson)).thenReturn((Object)true);
        List authorities = this.ePersonRestAuthenticationProvider.getGrantedAuthorities(this.context, this.ePerson);
        Assert.assertThat(authorities.stream().map(a -> a.getAuthority()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"ADMIN", "AUTHENTICATED"}));
    }

    @Test
    public void testGetGrantedAuthoritiesEPerson() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context, this.ePerson)).thenReturn((Object)false);
        List authorities = this.ePersonRestAuthenticationProvider.getGrantedAuthorities(this.context, this.ePerson);
        Assert.assertThat(authorities.stream().map(a -> a.getAuthority()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"AUTHENTICATED"}));
    }
}

