/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.utils.MultipartFileSender;
import org.dspace.authorize.AuthorizeException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class MultipartFileSenderTest {
    private static final Logger log = LogManager.getLogger(MultipartFileSenderTest.class);
    private InputStream is;
    private String mimeType;
    private long lastModified;
    private long length;
    private String fileName;
    private String checksum;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ContentCachingRequestWrapper requestWrapper;
    private ContentCachingResponseWrapper responseWrapper;

    @Before
    public void init() throws AuthorizeException {
        try {
            String content = "0123456789";
            this.is = IOUtils.toInputStream((String)content, (String)"UTF-8");
            this.fileName = "Test-Item.txt";
            this.mimeType = "text/plain";
            this.lastModified = new Date().getTime();
            this.length = content.getBytes().length;
            this.checksum = "testsum";
            this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.response = new MockHttpServletResponse();
            this.requestWrapper = new ContentCachingRequestWrapper(this.request);
            this.responseWrapper = new ContentCachingResponseWrapper(this.response);
        }
        catch (IOException ex) {
            log.error("IO Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @After
    public void destroy() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRangeHeader() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"If-Range"))).thenReturn((Object)"not_file_to_serve.txt");
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"Range"))).thenReturn((Object)"bytes=1-3");
        multipartFileSender.serveResource();
        String content = new String(this.responseWrapper.getContentAsByteArray(), "UTF-8");
        Assert.assertEquals((Object)"123", (Object)content);
    }

    @Test
    public void testFullFileReturn() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        multipartFileSender.serveResource();
        String content = new String(this.responseWrapper.getContentAsByteArray(), "UTF-8");
        Assert.assertEquals((Object)"0123456789", (Object)content);
        Assert.assertEquals((Object)this.checksum, (Object)this.responseWrapper.getHeader("ETag"));
    }

    @Test
    public void testOpenRange() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"Range"))).thenReturn((Object)"bytes=5-");
        multipartFileSender.serveResource();
        String content = new String(this.responseWrapper.getContentAsByteArray(), "UTF-8");
        Assert.assertEquals((Object)"56789", (Object)content);
    }

    @Test
    public void testMultipleRanges() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"Range"))).thenReturn((Object)"bytes=1-2,3-4,5-9");
        multipartFileSender.serveResource();
        String content = new String(this.responseWrapper.getContentAsByteArray(), "UTF-8");
        Assert.assertEquals((Object)("--MULTIPART_BYTERANGESContent-Type: text/plainContent-Range: bytes 1-2/1012--MULTIPART_BYTERANGESContent-Type: text/plainContent-Range: bytes 3-4/1034--MULTIPART_BYTERANGESContent-Type: text/plainContent-Range: bytes 5-9/1056789" + "--MULTIPART_BYTERANGES--".replace("\n", "").replace("\r", "")), (Object)content.replace("\n", "").replace("\r", ""));
    }

    @Test
    public void testInvalidRange() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"Range"))).thenReturn((Object)"bytes=invalid");
        multipartFileSender.serveResource();
        Assert.assertEquals((long)416L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testEtagInResponse() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"Range"))).thenReturn((Object)"bytes=1-3");
        multipartFileSender.serveResource();
        String etag = this.responseWrapper.getHeader("Etag");
        Assert.assertEquals((Object)this.checksum, (Object)etag);
    }

    @Test
    public void testHeadRequest() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getMethod()).thenReturn((Object)"HEAD");
        multipartFileSender.serveResource();
        String content = new String(this.responseWrapper.getContentAsByteArray(), "UTF-8");
        Assert.assertEquals((Object)"bytes", (Object)this.responseWrapper.getHeader("Accept-Ranges"));
        Assert.assertEquals((Object)this.checksum, (Object)this.responseWrapper.getHeader("ETag"));
        Assert.assertEquals((Object)"", (Object)content);
        Assert.assertEquals((long)200L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfNoneMatchFail() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"If-None-Match"))).thenReturn((Object)this.checksum);
        multipartFileSender.isValid();
        Assert.assertEquals((long)304L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfNoneMatchPass() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withFileName(this.fileName).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"If-None-Match"))).thenReturn((Object)"pretendthisisarandomchecksumnotequaltotherequestedbitstream");
        multipartFileSender.isValid();
        multipartFileSender.serveResource();
        Assert.assertEquals((long)200L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testNoFileName() throws Exception {
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).with((HttpServletResponse)this.responseWrapper).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length);
        multipartFileSender.isValid();
        Assert.assertEquals((long)500L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfModifiedSinceNotModifiedSince() throws Exception {
        Long time = new Date().getTime();
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).withFileName(this.fileName).with((HttpServletResponse)this.responseWrapper).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length).withLastModified(time.longValue());
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Modified-Since"))).thenReturn((Object)(time + 100000L));
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Unmodified-Since"))).thenReturn((Object)-1L);
        multipartFileSender.isValid();
        Assert.assertEquals((long)304L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfModifiedSinceModifiedSince() throws Exception {
        Long time = new Date().getTime();
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).withFileName(this.fileName).with((HttpServletResponse)this.responseWrapper).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length).withLastModified(time.longValue());
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Modified-Since"))).thenReturn((Object)(time - 100000L));
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Unmodified-Since"))).thenReturn((Object)-1L);
        multipartFileSender.isValid();
        multipartFileSender.serveResource();
        Assert.assertEquals((long)200L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfMatchNoMatch() throws Exception {
        Long time = new Date().getTime();
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).withFileName(this.fileName).with((HttpServletResponse)this.responseWrapper).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length).withLastModified(time.longValue());
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Modified-Since"))).thenReturn((Object)-1L);
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Unmodified-Since"))).thenReturn((Object)-1L);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"If-Match"))).thenReturn((Object)"None-Matching-ETAG");
        multipartFileSender.isValid();
        Assert.assertEquals((long)416L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfMatchMatch() throws Exception {
        Long time = new Date().getTime();
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).withFileName(this.fileName).with((HttpServletResponse)this.responseWrapper).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length).withLastModified(time.longValue());
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Modified-Since"))).thenReturn((Object)-1L);
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Unmodified-Since"))).thenReturn((Object)-1L);
        Mockito.when((Object)this.request.getHeader((String)ArgumentMatchers.eq((Object)"If-Match"))).thenReturn((Object)this.checksum);
        multipartFileSender.isValid();
        Assert.assertEquals((long)200L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfUnmodifiedSinceNotModifiedSince() throws Exception {
        Long time = new Date().getTime();
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).withFileName(this.fileName).with((HttpServletResponse)this.responseWrapper).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length).withLastModified(time.longValue());
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Unmodified-Since"))).thenReturn((Object)(time + 100000L));
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Modified-Since"))).thenReturn((Object)-1L);
        multipartFileSender.isValid();
        Assert.assertEquals((long)200L, (long)this.responseWrapper.getStatusCode());
    }

    @Test
    public void testIfUnmodifiedSinceModifiedSince() throws Exception {
        Long time = new Date().getTime();
        MultipartFileSender multipartFileSender = MultipartFileSender.fromInputStream((InputStream)this.is).with((HttpServletRequest)this.requestWrapper).withFileName(this.fileName).with((HttpServletResponse)this.responseWrapper).withChecksum(this.checksum).withMimetype(this.mimeType).withLength(this.length).withLastModified(time.longValue());
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Unmodified-Since"))).thenReturn((Object)(time - 100000L));
        Mockito.when((Object)this.request.getDateHeader((String)ArgumentMatchers.eq((Object)"If-Modified-Since"))).thenReturn((Object)-1L);
        multipartFileSender.isValid();
        Assert.assertEquals((long)412L, (long)this.responseWrapper.getStatusCode());
    }
}

