/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import com.google.gson.Gson;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ProcessStatus;
import org.dspace.core.Context;
import org.dspace.curate.CurationClientOptions;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CurationScriptIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;
    private static final String SCRIPTS_ENDPOINT = "/api/system/scripts";
    private static final String CURATE_SCRIPT_ENDPOINT = "/api/system/scripts/curate/processes";

    @Test
    public void curateScript_invalidTaskOption() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-t", "invalidTaskOption"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_MissingHandle() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_invalidHandle() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", "invalidhandle"));
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_MissingTaskOrTaskFile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_InvalidScope() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", "all"));
        parameters.add(new DSpaceCommandLineParameter("-s", "invalidScope"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_InvalidTaskFile() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", "all"));
        parameters.add(new DSpaceCommandLineParameter("-T", "invalidTaskFile"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void curateScript_validRequest_Task() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(this.admin.getID()), parameters, ProcessStatus.COMPLETED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void curateScript_validRequest_TaskFile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        File taskFile = new File(testProps.get("test.curateTaskFile").toString());
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-T", taskFile.getAbsolutePath()));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(this.admin.getID()), parameters, ProcessStatus.COMPLETED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void curateScript_EPersonInParametersFails() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-e", this.eperson.getEmail()));
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        AtomicReference idRef = new AtomicReference();
        this.context.restoreAuthSystemState();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).contentType("multipart/form-data").param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(this.admin.getID()), parameters, ProcessStatus.FAILED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }
}

