/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.SubmissionCCLicenseUrlRest;
import org.dspace.app.rest.model.wrapper.SubmissionCCLicenseUrl;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.Utils;
import org.dspace.core.Context;
import org.dspace.license.service.CreativeCommonsService;
import org.dspace.services.RequestService;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.Link;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissioncclicenseUrl")
public class SubmissionCCLicenseUrlRepository
extends DSpaceRestRepository<SubmissionCCLicenseUrlRest, String>
implements InitializingBean {
    @Autowired
    protected Utils utils;
    @Autowired
    protected CreativeCommonsService creativeCommonsService;
    @Autowired
    protected ConverterService converter;
    protected RequestService requestService = new DSpace().getRequestService();
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="rightsByQuestions")
    public SubmissionCCLicenseUrlRest findByRightsByQuestions() {
        ServletRequest servletRequest = this.requestService.getCurrentRequest().getServletRequest();
        Map requestParameterMap = servletRequest.getParameterMap();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String licenseId = servletRequest.getParameter("license");
        if (StringUtils.isBlank((CharSequence)licenseId)) {
            throw new DSpaceBadRequestException("A \"license\" parameter needs to be provided.");
        }
        for (String parameter : requestParameterMap.keySet()) {
            if (!StringUtils.startsWith((CharSequence)parameter, (CharSequence)"answer_")) continue;
            String field = StringUtils.substringAfter((String)parameter, (String)"answer_");
            String answer = "";
            if (((String[])requestParameterMap.get(parameter)).length > 0) {
                answer = ((String[])requestParameterMap.get(parameter))[0];
            }
            parameterMap.put(field, answer);
        }
        Map fullParamMap = this.creativeCommonsService.retrieveFullAnswerMap(licenseId, parameterMap);
        if (fullParamMap == null) {
            throw new ResourceNotFoundException("No CC License could be matched on the provided ID: " + licenseId);
        }
        boolean licenseContainsCorrectInfo = this.creativeCommonsService.verifyLicenseInformation(licenseId, fullParamMap);
        if (!licenseContainsCorrectInfo) {
            throw new DSpaceBadRequestException("The provided answers do not match the required fields for the provided license.");
        }
        String licenseUri = this.creativeCommonsService.retrieveLicenseUri(licenseId, fullParamMap);
        SubmissionCCLicenseUrl submissionCCLicenseUrl = new SubmissionCCLicenseUrl(licenseUri, licenseUri);
        if (StringUtils.isBlank((CharSequence)licenseUri)) {
            throw new ResourceNotFoundException("No CC License URI could be found for ID: " + licenseId);
        }
        return (SubmissionCCLicenseUrlRest)this.converter.toRest((Object)submissionCCLicenseUrl, this.utils.obtainProjection());
    }

    @PreAuthorize(value="permitAll()")
    public SubmissionCCLicenseUrlRest findOne(Context context, String s) {
        throw new RepositoryMethodNotImplementedException("submissioncclicenseUrl", "findOne");
    }

    public Page<SubmissionCCLicenseUrlRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("submissioncclicenseUrl", "findAll");
    }

    public Class<SubmissionCCLicenseUrlRest> getDomainClass() {
        return SubmissionCCLicenseUrlRest.class;
    }

    public void afterPropertiesSet() {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(new Link("/api/config/submissioncclicenseUrl/search", "submissioncclicenseUrl-search")));
    }
}

