/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.authorization.AuthorizeServiceRestUtil;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canCreateBitstream", description="It can be used to verify if bitstreams can be created in a specific bundle")
public class CreateBitstreamFeature
implements AuthorizationFeature {
    Logger log = Logger.getLogger(CreateBitstreamFeature.class);
    public static final String NAME = "canCreateBitstream";
    @Autowired
    private AuthorizeServiceRestUtil authorizeServiceRestUtil;
    @Autowired
    private BundleService bundleService;
    @Autowired
    private Utils utils;
    @Autowired
    private AuthorizeService authorizeService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof BundleRest) {
            if (!this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.WRITE)) {
                return false;
            }
            if (!this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.ADD)) {
                return false;
            }
            DSpaceObject owningObject = this.bundleService.getParentObject(context, (DSpaceObject)((Bundle)this.utils.getDSpaceAPIObjectFromRest(context, object)));
            if (!(owningObject instanceof Item)) {
                this.log.error((Object)("The parent object of bundle " + object.getType() + " is not an item"));
                return false;
            }
            if (!this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), owningObject, 1, true)) {
                return false;
            }
            return this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), owningObject, 3, true);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.bundle"};
    }
}

