/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.authorization.AuthorizeServiceRestUtil;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canMove", description="It can be used to verify if item can be moved to a different collection")
public class MoveFeature
implements AuthorizationFeature {
    Logger log = Logger.getLogger(MoveFeature.class);
    public static final String NAME = "canMove";
    @Autowired
    private AuthorizeServiceRestUtil authorizeServiceRestUtil;
    @Autowired
    private Utils utils;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AuthorizeService authorizeService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof ItemRest) {
            if (!this.authorizeServiceRestUtil.authorizeActionBoolean(context, object, DSpaceRestPermission.WRITE)) {
                return false;
            }
            DSpaceObject owningObject = this.itemService.getParentObject(context, (DSpaceObject)((Item)this.utils.getDSpaceAPIObjectFromRest(context, object)));
            if (!(owningObject instanceof Collection)) {
                this.log.error((Object)("The partent object of item " + object.getType() + " is not a collection"));
                return false;
            }
            return this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), owningObject, 4, true);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

