/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.Map;
import java.util.UUID;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BundleUploadBitstreamControllerIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private AuthorizeService authorizeService;

    @Test
    public void uploadBitstreamAllPossibleFieldsProperties() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("TESTINGBUNDLE").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String input = "Hello, World!";
        MockMultipartFile file = new MockMultipartFile("file", "hello.txt", "text/plain", input.getBytes());
        BitstreamRest bitstreamRest = new BitstreamRest();
        bitstreamRest.setName("testing");
        MetadataRest metadataRest = new MetadataRest();
        MetadataValueRest description = new MetadataValueRest();
        description.setValue("description");
        metadataRest.put("dc.description", new MetadataValueRest[]{description});
        MetadataValueRest contents = new MetadataValueRest();
        contents.setValue("News");
        metadataRest.put("dc.description.tableofcontents", new MetadataValueRest[]{contents});
        MetadataValueRest copyright = new MetadataValueRest();
        copyright.setValue("Custom Copyright Text");
        metadataRest.put("dc.rights", new MetadataValueRest[]{copyright});
        MetadataValueRest title = new MetadataValueRest();
        title.setValue("Title Text");
        metadataRest.put("dc.title", new MetadataValueRest[]{title});
        bitstreamRest.setMetadata(metadataRest);
        ObjectMapper mapper = new ObjectMapper();
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).file(file).param("properties", new String[]{mapper.writeValueAsString((Object)bitstreamRest)})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"testing"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.bundleName", (Matcher)Matchers.is((Object)"TESTINGBUNDLE"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "description"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "News"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "testing")))}))).andReturn();
        String content = mvcResult.getResponse().getContentAsString();
        Map map = (Map)mapper.readValue(content, Map.class);
        String bitstreamId = String.valueOf(map.get("id"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"_embedded.bitstreams", (Matcher)Matchers.hasItem(BitstreamMatcher.matchBitstreamEntry(UUID.fromString(bitstreamId), file.getSize(), bitstreamRest.getName(), "description"))));
    }

    @Test
    public void uploadBitstreamNoProperties() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("TESTINGBUNDLE").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String input = "Hello, World!";
        MockMultipartFile file = new MockMultipartFile("file", "hello.txt", "text/plain", input.getBytes());
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.bundleName", (Matcher)Matchers.is((Object)"TESTINGBUNDLE"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"hello.txt"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sequenceId", (Matcher)Matchers.is((Object)1))).andReturn();
        ObjectMapper mapper = new ObjectMapper();
        String content = mvcResult.getResponse().getContentAsString();
        Map map = (Map)mapper.readValue(content, Map.class);
        String bitstreamId = String.valueOf(map.get("id"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"_embedded.bitstreams", (Matcher)Matchers.hasItem(BitstreamMatcher.matchBitstreamEntry(UUID.fromString(bitstreamId), file.getSize()))));
    }

    @Test
    public void uploadBitstreamNoPropertiesUserWithItemAddAndWriteRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("TESTINGBUNDLE").build();
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)bundle, 3, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)bundle, 1, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)item, 3, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)item, 1, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String input = "Hello, World!";
        MockMultipartFile file = new MockMultipartFile("file", "hello.txt", "text/plain", input.getBytes());
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)IsNull.notNullValue())).andReturn();
        ObjectMapper mapper = new ObjectMapper();
        String content = mvcResult.getResponse().getContentAsString();
        Map map = (Map)mapper.readValue(content, Map.class);
        String bitstreamId = String.valueOf(map.get("id"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"_embedded.bitstreams", (Matcher)Matchers.hasItem(BitstreamMatcher.matchBitstreamEntry(UUID.fromString(bitstreamId), file.getSize()))));
    }

    @Test
    public void uploadBitstreamNoRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("TESTINGBUNDLE").build();
        this.context.setCurrentUser(this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String input = "Hello, World!";
        MockMultipartFile file = new MockMultipartFile("file", "hello.txt", "text/plain", input.getBytes());
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"_embedded.bitstreams", (Object[])new Object[0]).isEmpty());
    }

    @Test
    public void uploadBitstreamAnonymous() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("TESTINGBUNDLE").build();
        this.context.setCurrentUser(this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String input = "Hello, World!";
        MockMultipartFile file = new MockMultipartFile("file", "hello.txt", "text/plain", input.getBytes());
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).file(file)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"_embedded.bitstreams", (Object[])new Object[0]).isEmpty());
    }

    @Test
    public void uploadBitstreamMinimalProperties() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("TESTINGBUNDLE").build();
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)bundle, 3, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)bundle, 1, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)item, 3, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)item, 1, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String input = "Hello, World!";
        MockMultipartFile file = new MockMultipartFile("file", "hello.txt", "text/plain", input.getBytes());
        BitstreamRest bitstreamRest = new BitstreamRest();
        ObjectMapper mapper = new ObjectMapper();
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).file(file).param("properties", new String[]{mapper.writeValueAsString((Object)bitstreamRest)})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.bundleName", (Matcher)Matchers.is((Object)"TESTINGBUNDLE"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)IsNull.notNullValue())).andReturn();
        String content = mvcResult.getResponse().getContentAsString();
        Map map = (Map)mapper.readValue(content, Map.class);
        String bitstreamId = String.valueOf(map.get("id"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"_embedded.bitstreams", (Matcher)Matchers.hasItem(BitstreamMatcher.matchBitstreamEntry(UUID.fromString(bitstreamId), file.getSize()))));
    }

    @Test
    @Ignore
    public void uploadBitstreamMultipleFiles() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("TESTINGBUNDLE").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String input = "Hello, World!";
        MockMultipartFile file = new MockMultipartFile("file", "hello1.txt", "text/plain", input.getBytes());
        MockMultipartFile file2 = new MockMultipartFile("file", "hello2.txt", "text/plain", input.getBytes());
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/core/bundles/" + bundle.getID() + "/bitstreams"), (Object[])new Object[0]).file(file).file(file2)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }
}

