/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.jackson.IgnoreJacksonWriteOnlyAccess;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.GroupMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.RegistrationRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.PasswordHash;
import org.dspace.eperson.dao.RegistrationDataDAO;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.RegistrationDataService;
import org.dspace.services.ConfigurationService;
import org.dspace.workflow.WorkflowService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EPersonRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AccountService accountService;
    @Autowired
    private RegistrationDataService registrationDataService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private RegistrationDataDAO registrationDataDAO;
    @Autowired
    private ConfigurationService configurationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        EPersonRest data = new EPersonRest();
        EPersonRest dataFull = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        data.setEmail("createtest@example.com");
        data.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        data.setMetadata(metadataRest);
        dataFull.setEmail("createtestFull@example.com");
        dataFull.setCanLogIn(true);
        dataFull.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRefNoEmbeds = new AtomicReference();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)data)).contentType(this.contentType).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", EPersonMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.email", (Matcher)Matchers.is((Object)"createtest@example.com")), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), JsonPathMatchers.hasJsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true)), JsonPathMatchers.hasJsonPath((String)"$.requireCertificate", (Matcher)Matchers.is((Object)false)), JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", "John"), MetadataMatcher.matchMetadata("eperson.lastname", "Doe"), MetadataMatcher.matchMetadataDoesNotExist("dc.identifier.uri")))}))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)dataFull)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andDo(result -> idRefNoEmbeds.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        finally {
            EPersonBuilder.deleteEPerson((UUID)((UUID)idRef.get()));
            EPersonBuilder.deleteEPerson((UUID)((UUID)idRefNoEmbeds.get()));
        }
    }

    @Test
    public void createAnonAccessDeniedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ObjectMapper mapper = new ObjectMapper();
        EPersonRest data = new EPersonRest();
        EPersonRest dataFull = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        data.setEmail("createtest@fake-email.com");
        data.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        data.setMetadata(metadataRest);
        dataFull.setEmail("createtestFull@fake-email.com");
        dataFull.setCanLogIn(true);
        dataFull.setMetadata(metadataRest);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)data)).contentType(this.contentType).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byEmail", (Object[])new Object[0]).param("email", new String[]{data.getEmail()})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson newUser = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/eperson", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(newUser), EPersonMatcher.matchEPersonOnEmail(this.admin.getEmail()), EPersonMatcher.matchEPersonOnEmail(this.eperson.getEmail())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/eperson", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/eperson", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson testEPerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(testEPerson), EPersonMatcher.matchEPersonOnEmail(this.admin.getEmail())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.not((Matcher)Matchers.contains(EPersonMatcher.matchEPersonOnEmail(this.eperson.getEmail()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.contains(EPersonMatcher.matchEPersonOnEmail(this.eperson.getEmail())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson2.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", EPersonMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(ePerson2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(ePerson)))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Mik", "Reck").withEmail("MikReck@email.com").withPassword("qwerty01").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Bob", "Smith").withEmail("bobsmith@example.com").build();
        this.context.restoreAuthSystemState();
        String tokenEperson1 = this.getAuthToken(ePerson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void readEpersonAuthorizationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(ePerson2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(ePerson1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/epersons/" + ePerson2.getID()))));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + this.eperson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(this.eperson.getEmail())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/epersons/" + this.eperson.getID()))));
    }

    @Test
    public void findOneTestWrongUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson testEPerson1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson testEPerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void searchMethodsExist() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.search.href", (Matcher)Matchers.notNullValue()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.byEmail", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.byMetadata", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void findByEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byEmail", (Object[])new Object[0]).param("email", new String[]{ePerson.getEmail()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(ePerson))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byEmail", (Object[])new Object[0]).param("email", new String[]{ePerson.getEmail().toUpperCase()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(EPersonMatcher.matchEPersonEntry(ePerson))));
    }

    @Test
    public void findByEmailUndefined() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byEmail", (Object[])new Object[0]).param("email", new String[]{"undefined@undefined.com"})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findByEmailMissingParameter() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byEmail", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByMetadataUsingLastName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        EPerson ePerson3 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Tom", "Doe").withEmail("tomdoe@example.com").build();
        EPerson ePerson4 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Dirk", "Doe-Postfix").withEmail("dirkdoepostfix@example.com").build();
        EPerson ePerson5 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Harry", "Prefix-Doe").withEmail("harrydoeprefix@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getLastName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(ePerson), EPersonMatcher.matchEPersonEntry(ePerson3), EPersonMatcher.matchEPersonEntry(ePerson4), EPersonMatcher.matchEPersonEntry(ePerson5)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getLastName().toLowerCase()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(ePerson), EPersonMatcher.matchEPersonEntry(ePerson3), EPersonMatcher.matchEPersonEntry(ePerson4), EPersonMatcher.matchEPersonEntry(ePerson5)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
    }

    @Test
    public void findByMetadataUsingFirstName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        EPerson ePerson3 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Smith").withEmail("tomdoe@example.com").build();
        EPerson ePerson4 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John-Postfix", "Smath").withEmail("dirkdoepostfix@example.com").build();
        EPerson ePerson5 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Prefix-John", "Smoth").withEmail("harrydoeprefix@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getFirstName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(ePerson), EPersonMatcher.matchEPersonEntry(ePerson3), EPersonMatcher.matchEPersonEntry(ePerson4), EPersonMatcher.matchEPersonEntry(ePerson5)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getFirstName().toLowerCase()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(ePerson), EPersonMatcher.matchEPersonEntry(ePerson3), EPersonMatcher.matchEPersonEntry(ePerson4), EPersonMatcher.matchEPersonEntry(ePerson5)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
    }

    @Test
    public void findByMetadataUsingEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        EPerson ePerson3 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Tom", "Doe").withEmail("tomdoe@example.com").build();
        EPerson ePerson4 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Dirk", "Doe-Postfix").withEmail("dirkdoepostfix@example.com").build();
        EPerson ePerson5 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Harry", "Prefix-Doe").withEmail("harrydoeprefix@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getEmail()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.contains(EPersonMatcher.matchEPersonEntry(ePerson)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getEmail().toLowerCase()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.contains(EPersonMatcher.matchEPersonEntry(ePerson)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByMetadataUsingUuid() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        EPerson ePerson3 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Tom", "Doe").withEmail("tomdoe@example.com").build();
        EPerson ePerson4 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Dirk", "Doe-Postfix").withEmail("dirkdoepostfix@example.com").build();
        EPerson ePerson5 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Harry", "Prefix-Doe").withEmail("harrydoeprefix@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{String.valueOf(ePerson.getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.contains(EPersonMatcher.matchEPersonEntry(ePerson)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{String.valueOf(ePerson.getID()).toLowerCase()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.contains(EPersonMatcher.matchEPersonEntry(ePerson)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByMetadataUnauthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Doe, John"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByMetadataForbidden() throws Exception {
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Doe, John"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByMetadataUndefined() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Doe, John"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByMetadataMissingParameter() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void deleteOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteViolatingWorkFlowConstraints() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Sample", "Submitter").withEmail("submitter@example.com").build();
        this.context.setCurrentUser(ePerson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withLogo("logo_community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withLogo("logo_collection").withWorkflowGroup(1, new EPerson[]{ePerson}).build();
        WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteLastPersonInWorkflowGroup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson@example.com").withNameInMetadata("Sample", "EPerson").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withWorkflowGroup(1, new EPerson[]{ePerson}).build();
        Group workflowGroup = collection.getWorkflowStep1(this.context);
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("webui.supported.locales", (Object)"en, pl");
        String key = "org.dspace.app.rest.exception.RESTEmptyWorkflowGroupException.message";
        String[] values = new String[]{ePerson.getID().toString(), workflowGroup.getID().toString()};
        MessageFormat defaultFmt = new MessageFormat(I18nUtil.getMessage((String)key));
        MessageFormat plFmt = new MessageFormat(I18nUtil.getMessage((String)key, (Locale)new Locale("pl")));
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).header("Accept-Language", new Object[]{"pl"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)plFmt.format(values)))).andExpect(MockMvcResultMatchers.status().reason(Matchers.startsWith((String)"[PL]")));
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)defaultFmt.format(values)))).andExpect(MockMvcResultMatchers.status().reason(Matchers.not((Matcher)Matchers.startsWith((String)"[PL]"))));
    }

    @Test
    public void patchByForbiddenUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/netid", (Object)"newNetId");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
    }

    @Test
    public void patchByAnonymousUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/netid", (Object)"newNetId");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
    }

    @Test
    public void patchNetId() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withNetId("testId").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/netid", (Object)"newNetId");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Object)"newNetId"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void patchUsingStringForBoolean() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withNetId("testId").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/canLogin", (Object)"true");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Object)"testId"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true)));
        replaceOperation = new ReplaceOperation("/canLogin", (Object)"false");
        ops.set(0, (Operation)replaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Object)"testId"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void replaceOnNonExistentValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/netid", (Object)"newNetId");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchNetIdMissingValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withNetId("testId").build();
        this.context.restoreAuthSystemState();
        String newId = "newId";
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/netid", (Object)newId);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Object)newId)));
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        ReplaceOperation replaceOperation2 = new ReplaceOperation("/netid", null);
        ops2.add((Operation)replaceOperation2);
        patchBody = this.getPatchContent(ops2);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Object)newId))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void patchCanLogin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/canLogin", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.cookie().doesNotExist("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().doesNotExist("DSPACE-XSRF-TOKEN"));
    }

    @Test
    public void patchCanLoginMissingValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/canLogin", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true)));
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        ReplaceOperation replaceOperation2 = new ReplaceOperation("/canLogin", null);
        ops2.add((Operation)replaceOperation2);
        patchBody = this.getPatchContent(ops2);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requireCertificate", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void patchRequireCertificate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/certificate", (Object)false);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requireCertificate", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchRequireCertificateMissingValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/certificate", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requireCertificate", (Matcher)Matchers.is((Object)true)));
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        ReplaceOperation replaceOperation2 = new ReplaceOperation("/certificate", null);
        ops2.add((Operation)replaceOperation2);
        patchBody = this.getPatchContent(ops2);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requireCertificate", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)"johndoe@example.com"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void patchPassword() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String newPassword = "newpassword";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        token = this.getAuthToken(ePerson.getEmail(), newPassword);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchPasswordIsForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Doe").withEmail("Janedoe@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String newPassword = "newpassword";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(ePerson1.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(ePerson2.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        token = this.getAuthToken(ePerson2.getEmail(), newPassword);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchPasswordForNonAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String newPassword = "newpassword";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        token = this.getAuthToken(ePerson.getEmail(), newPassword);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchPasswordReplaceOnNonExistentValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String newPassword = "newpassword";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        token = this.getAuthToken(ePerson.getEmail(), newPassword);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchCanLoginNonAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("CanLogin@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        ReplaceOperation replaceOperation = new ReplaceOperation("/canLogin", (Object)true);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchCertificateNonAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("CanLogin@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        ReplaceOperation replaceOperation = new ReplaceOperation("/certificate", (Object)true);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchPasswordMissingValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String originalPw = "testpass79bC";
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(originalPw).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", null);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        token = this.getAuthToken(ePerson.getEmail(), originalPw);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        token = this.getAuthToken(ePerson.getEmail(), null);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchPasswordNotInitialised() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("userNotInitialised@example.com").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String newPassword = "newpass";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        token = this.getAuthToken(ePerson.getEmail(), newPassword);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String newEmail = "janedoe@real-email.com";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/email", (Object)newEmail);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.email", (Matcher)Matchers.is((Object)newEmail))).andExpect(MockMvcResultMatchers.status().isOk());
        token = this.getAuthToken(newEmail, this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchEmailNonAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String newEmail = "new@email.com";
        ReplaceOperation replaceOperation = new ReplaceOperation("/email", (Object)newEmail);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchEmailMissingValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation2 = new ReplaceOperation("/email", null);
        ops.add((Operation)replaceOperation2);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
    }

    @Test
    public void patchMultipleOperationsWithSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withNetId("testId").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation1 = new ReplaceOperation("/canLogin", (Object)true);
        ops.add((Operation)replaceOperation1);
        ReplaceOperation replaceOperation2 = new ReplaceOperation("/netid", (Object)"multitestId");
        ops.add((Operation)replaceOperation2);
        ReplaceOperation replaceOperation3 = new ReplaceOperation("/certificate", (Object)true);
        ops.add((Operation)replaceOperation3);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.is((Object)"multitestId"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.requireCertificate", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void patchMultipleOperationsWithFailure() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation0 = new ReplaceOperation("/canLogin", (Object)true);
        ops.add((Operation)replaceOperation0);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true)));
        ReplaceOperation replaceOperation1 = new ReplaceOperation("/canLogin", (Object)false);
        ops.add((Operation)replaceOperation1);
        ReplaceOperation replaceOperation2 = new ReplaceOperation("/certificate", (Object)true);
        ops.add((Operation)replaceOperation2);
        ReplaceOperation replaceOperation3 = new ReplaceOperation("/nonexistentPath", (Object)"somevalue");
        ops.add((Operation)replaceOperation3);
        ReplaceOperation replaceOperation4 = new ReplaceOperation("/certificate", (Object)false);
        ops.add((Operation)replaceOperation4);
        patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.canLogIn", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void patchEPersonMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchEPersonMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("user@example.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/eperson/epersons/" + ePerson.getID(), expectedStatus);
    }

    @Test
    public void patchMetadataByAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        String newName = "JohnReplace";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/metadata/eperson.firstname", (Object)newName);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("eperson.firstname", newName)})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("eperson.firstname", newName)}))));
    }

    @Test
    public void patchOwnMetadataByNonAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        String newName = "JohnReplace";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/metadata/eperson.firstname", (Object)newName);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("eperson.firstname", newName)})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("eperson.firstname", newName)}))));
    }

    @Test
    public void patchNotOwnMetadataByNonAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("Janesmith@example.com").withPassword(this.password).build();
        String newName = "JohnReplace";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/metadata/eperson.firstname", (Object)newName);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token2 = this.getAuthToken(ePerson2.getEmail(), this.password);
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token2).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("eperson.firstname", "John")}))));
    }

    @Test
    public void newlyCreatedAccountHasNoGroups() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Mik", "Reck").withEmail("MikReck@email.com").withPassword("qwerty01").build();
        this.context.restoreAuthSystemState();
        String tokenEperson1 = this.getAuthToken(ePerson1.getEmail(), "qwerty01");
        this.getClient(tokenEperson1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.groups._embedded.groups.length()", (Matcher)Matchers.is((Object)0)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.groups.page.totalElements", (Matcher)Matchers.is((Object)0)))));
    }

    @Test
    public void getDirectEpersonGroups() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        Group parentGroup1 = GroupBuilder.createGroup((Context)this.context).withName("Test Parent Group 1").build();
        Group childGroup1 = GroupBuilder.createGroup((Context)this.context).withName("Test Child Group 1").withParent(parentGroup1).addMember(ePerson).build();
        Group parentGroup2 = GroupBuilder.createGroup((Context)this.context).withName("Test Parent Group 2").build();
        Group childGroup2 = GroupBuilder.createGroup((Context)this.context).withName("Test Child Group 2").withParent(parentGroup2).addMember(ePerson).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/epersons/" + ePerson.getID() + "/groups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupWithName(childGroup1.getName()), GroupMatcher.matchGroupWithName(childGroup2.getName())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupWithName(parentGroup1.getName()), GroupMatcher.matchGroupWithName(parentGroup2.getName())}))));
    }

    @Test
    public void patchReplacePasswordWithToken() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@fake-email.com").withPassword(this.password).build();
        String newPassword = "newpassword";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.accountService.sendRegistrationInfo(this.context, ePerson.getEmail());
        String tokenForEPerson = this.registrationDataService.findByEmail(this.context, ePerson.getEmail()).getToken();
        PasswordHash oldPassword = this.ePersonService.getPasswordHash(ePerson);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json").param("token", new String[]{tokenForEPerson})).andExpect(MockMvcResultMatchers.status().isOk());
        PasswordHash newPasswordHash = this.ePersonService.getPasswordHash(ePerson);
        Assert.assertNotEquals((Object)oldPassword, (Object)newPasswordHash);
        Assert.assertTrue((this.registrationDataService.findByEmail(this.context, ePerson.getEmail()) == null ? 1 : 0) != 0);
        Assert.assertNull((Object)this.registrationDataService.findByToken(this.context, tokenForEPerson));
    }

    @Test
    public void patchReplacePasswordWithRandomTokenPatchFail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@fake-email.com").withPassword(this.password).build();
        String newPassword = "newpassword";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.accountService.sendRegistrationInfo(this.context, ePerson.getEmail());
        String tokenForEPerson = this.registrationDataService.findByEmail(this.context, ePerson.getEmail()).getToken();
        PasswordHash oldPassword = this.ePersonService.getPasswordHash(ePerson);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json").param("token", new String[]{"RandomToken"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        PasswordHash newPasswordHash = this.ePersonService.getPasswordHash(ePerson);
        Assert.assertEquals((Object)oldPassword.getHashString(), (Object)newPasswordHash.getHashString());
        Assert.assertNotNull((Object)this.registrationDataService.findByEmail(this.context, ePerson.getEmail()));
        Assert.assertEquals((Object)this.registrationDataService.findByEmail(this.context, ePerson.getEmail()).getToken(), (Object)tokenForEPerson);
        this.context.turnOffAuthorisationSystem();
        this.registrationDataService.deleteByToken(this.context, tokenForEPerson);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void patchReplacePasswordWithOtherUserTokenFail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@fake-email.com").withPassword(this.password).build();
        EPerson ePersonTwo = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Smith", "Donald").withEmail("donaldSmith@fake-email.com").withPassword(this.password).build();
        String newPassword = "newpassword";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.accountService.sendRegistrationInfo(this.context, ePerson.getEmail());
        this.accountService.sendRegistrationInfo(this.context, ePersonTwo.getEmail());
        String tokenForEPerson = this.registrationDataService.findByEmail(this.context, ePerson.getEmail()).getToken();
        String tokenForEPersonTwo = this.registrationDataService.findByEmail(this.context, ePersonTwo.getEmail()).getToken();
        PasswordHash oldPassword = this.ePersonService.getPasswordHash(ePerson);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json").param("token", new String[]{tokenForEPersonTwo})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        PasswordHash newPasswordHash = this.ePersonService.getPasswordHash(ePerson);
        Assert.assertEquals((Object)oldPassword.getHashString(), (Object)newPasswordHash.getHashString());
        Assert.assertNotNull((Object)this.registrationDataService.findByEmail(this.context, ePerson.getEmail()));
        this.context.turnOffAuthorisationSystem();
        this.registrationDataService.deleteByToken(this.context, tokenForEPerson);
        this.registrationDataService.deleteByToken(this.context, tokenForEPersonTwo);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void patchReplaceEmailWithTokenFail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String originalEmail = "johndoe@fake-email.com";
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail(originalEmail).withPassword(this.password).build();
        String newEmail = "johnyandmaria@fake-email.com";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/email", (Object)newEmail);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.accountService.sendRegistrationInfo(this.context, ePerson.getEmail());
        String tokenForEPerson = this.registrationDataService.findByEmail(this.context, ePerson.getEmail()).getToken();
        PasswordHash oldPassword = this.ePersonService.getPasswordHash(ePerson);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json").param("token", new String[]{tokenForEPerson})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        PasswordHash newPasswordHash = this.ePersonService.getPasswordHash(ePerson);
        Assert.assertEquals((Object)oldPassword.getHashString(), (Object)newPasswordHash.getHashString());
        Assert.assertNotNull((Object)this.registrationDataService.findByEmail(this.context, ePerson.getEmail()));
        Assert.assertEquals((Object)ePerson.getEmail(), (Object)originalEmail);
        this.context.turnOffAuthorisationSystem();
        this.registrationDataService.delete(this.context, (Object)this.registrationDataService.findByEmail(this.context, ePerson.getEmail()));
        this.registrationDataService.deleteByToken(this.context, tokenForEPerson);
        this.context.restoreAuthSystemState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registerNewAccountPatchUpdatePasswordRandomUserUuidFail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@fake-email.com").withPassword(this.password).build();
        String newPassword = "newpassword";
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.accountService.sendRegistrationInfo(this.context, ePerson.getEmail());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        PasswordHash oldPassword = this.ePersonService.getPasswordHash(ePerson);
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json").param("token", new String[]{newRegisterToken})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
            PasswordHash newPasswordHash = this.ePersonService.getPasswordHash(ePerson);
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)oldPassword.getHashString(), (CharSequence)newPasswordHash.getHashString()));
            Assert.assertFalse((this.registrationDataService.findByEmail(this.context, ePerson.getEmail()) == null ? 1 : 0) != 0);
            Assert.assertFalse((this.registrationDataService.findByEmail(this.context, newRegisterEmail) == null ? 1 : 0) != 0);
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.delete(this.context, (Object)this.registrationDataService.findByEmail(this.context, ePerson.getEmail()));
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithoutEmailProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        AtomicReference idRef = new AtomicReference();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", "John"), MetadataMatcher.matchMetadata("eperson.lastname", "Doe")))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            String epersonUuid = String.valueOf(idRef.get());
            EPerson createdEPerson = (EPerson)this.ePersonService.find(this.context, UUID.fromString(epersonUuid));
            Assert.assertTrue((boolean)this.ePersonService.checkPassword(this.context, createdEPerson, "somePassword"));
            Assert.assertNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
            EPersonBuilder.deleteEPerson((UUID)((UUID)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithEmailProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        AtomicReference idRef = new AtomicReference();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.email", (Matcher)Matchers.is((Object)newRegisterEmail)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", "John"), MetadataMatcher.matchMetadata("eperson.lastname", "Doe")))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            String epersonUuid = String.valueOf(idRef.get());
            EPerson createdEPerson = (EPerson)this.ePersonService.find(this.context, UUID.fromString(epersonUuid));
            Assert.assertTrue((boolean)this.ePersonService.checkPassword(this.context, createdEPerson, "somePassword"));
            Assert.assertNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
            EPersonBuilder.deleteEPerson((UUID)((UUID)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithEmailAndSelfRegisteredProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        ePersonRest.setSelfRegistered(Boolean.valueOf(true));
        AtomicReference idRef = new AtomicReference();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.email", (Matcher)Matchers.is((Object)newRegisterEmail)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", "John"), MetadataMatcher.matchMetadata("eperson.lastname", "Doe")))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            String epersonUuid = String.valueOf(idRef.get());
            EPerson createdEPerson = (EPerson)this.ePersonService.find(this.context, UUID.fromString(epersonUuid));
            Assert.assertTrue((boolean)this.ePersonService.checkPassword(this.context, createdEPerson, "somePassword"));
            Assert.assertNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
            EPersonBuilder.deleteEPerson((UUID)((UUID)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithTwoTokensDifferentEmailProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        String newRegisterEmailTwo = "new-register-two@fake-email.com";
        RegistrationRest registrationRestTwo = new RegistrationRest();
        registrationRestTwo.setEmail(newRegisterEmailTwo);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRestTwo))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterTokenTwo = this.registrationDataService.findByEmail(this.context, newRegisterEmailTwo).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmailTwo);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
            EPerson createdEPerson = this.ePersonService.findByEmail(this.context, newRegisterEmailTwo);
            Assert.assertNull((Object)createdEPerson);
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, newRegisterTokenTwo));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.registrationDataService.deleteByToken(this.context, newRegisterTokenTwo);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithRandomTokenWithEmailProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{"randomToken"}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
            EPerson createdEPerson = this.ePersonService.findByEmail(this.context, newRegisterEmail);
            Assert.assertNull((Object)createdEPerson);
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithEmailAndSelfRegisteredFalseProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        ePersonRest.setSelfRegistered(Boolean.valueOf(false));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
            EPerson createdEPerson = this.ePersonService.findByEmail(this.context, newRegisterEmail);
            Assert.assertNull((Object)createdEPerson);
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithoutLastNameProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        ePersonRest.setSelfRegistered(Boolean.valueOf(true));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        this.configurationService.setProperty("webui.supported.locales", (Object)"en, pl");
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).header("Accept-Language", new Object[]{"pl"}).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)I18nUtil.getMessage((String)"org.dspace.app.rest.exception.EPersonNameNotProvidedException.message", (Locale)new Locale("pl"))))).andExpect(MockMvcResultMatchers.status().reason(Matchers.startsWith((String)"[PL]")));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)I18nUtil.getMessage((String)"org.dspace.app.rest.exception.EPersonNameNotProvidedException.message")))).andExpect(MockMvcResultMatchers.status().reason(Matchers.not((Matcher)Matchers.startsWith((String)"[PL]"))));
            EPerson createdEPerson = this.ePersonService.findByEmail(this.context, newRegisterEmail);
            Assert.assertNull((Object)createdEPerson);
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithoutFirstNameProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        ePersonRest.setSelfRegistered(Boolean.valueOf(true));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        this.configurationService.setProperty("webui.supported.locales", (Object)"en, pl");
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).header("Accept-Language", new Object[]{"pl"}).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)I18nUtil.getMessage((String)"org.dspace.app.rest.exception.EPersonNameNotProvidedException.message", (Locale)new Locale("pl"))))).andExpect(MockMvcResultMatchers.status().reason(Matchers.startsWith((String)"[PL]")));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)I18nUtil.getMessage((String)"org.dspace.app.rest.exception.EPersonNameNotProvidedException.message")))).andExpect(MockMvcResultMatchers.status().reason(Matchers.not((Matcher)Matchers.startsWith((String)"[PL]"))));
            EPerson createdEPerson = this.ePersonService.findByEmail(this.context, newRegisterEmail);
            Assert.assertNull((Object)createdEPerson);
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithoutPasswordProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
            EPerson createdEPerson = this.ePersonService.findByEmail(this.context, newRegisterEmail);
            Assert.assertNull((Object)createdEPerson);
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithWrongToken() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newEmail = "new-email@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String forgotPasswordToken = this.registrationDataService.findByEmail(this.context, this.eperson.getEmail()).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        ePersonRest.setSelfRegistered(Boolean.valueOf(true));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{forgotPasswordToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
            EPerson createdEPerson = this.ePersonService.findByEmail(this.context, newEmail);
            Assert.assertNull((Object)createdEPerson);
            Assert.assertNotNull((Object)this.registrationDataService.findByToken(this.context, forgotPasswordToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, forgotPasswordToken);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void postEPersonWithTokenWithEmailPropertyAnonUser() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String newRegisterEmail = "new-register@fake-email.com";
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(newRegisterEmail);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).contentType("application/json").content(mapper.writeValueAsBytes((Object)registrationRest))).andExpect(MockMvcResultMatchers.status().isCreated());
        String newRegisterToken = this.registrationDataService.findByEmail(this.context, newRegisterEmail).getToken();
        EPersonRest ePersonRest = new EPersonRest();
        MetadataRest metadataRest = new MetadataRest();
        ePersonRest.setEmail(newRegisterEmail);
        ePersonRest.setCanLogIn(true);
        MetadataValueRest surname = new MetadataValueRest();
        surname.setValue("Doe");
        metadataRest.put("eperson.lastname", new MetadataValueRest[]{surname});
        MetadataValueRest firstname = new MetadataValueRest();
        firstname.setValue("John");
        metadataRest.put("eperson.firstname", new MetadataValueRest[]{firstname});
        ePersonRest.setMetadata(metadataRest);
        ePersonRest.setPassword("somePassword");
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJacksonWriteOnlyAccess());
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/epersons", (Object[])new Object[0]).param("token", new String[]{newRegisterToken}).content(mapper.writeValueAsBytes((Object)ePersonRest)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.email", (Matcher)Matchers.is((Object)newRegisterEmail)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", "John"), MetadataMatcher.matchMetadata("eperson.lastname", "Doe")))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            String epersonUuid = String.valueOf(idRef.get());
            EPerson createdEPerson = (EPerson)this.ePersonService.find(this.context, UUID.fromString(epersonUuid));
            Assert.assertTrue((boolean)this.ePersonService.checkPassword(this.context, createdEPerson, "somePassword"));
            Assert.assertNull((Object)this.registrationDataService.findByToken(this.context, newRegisterToken));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.registrationDataService.deleteByToken(this.context, newRegisterToken);
            this.context.restoreAuthSystemState();
            EPersonBuilder.deleteEPerson((UUID)((UUID)idRef.get()));
        }
    }

    @Test
    public void findByMetadataByCommAdminAndByColAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson colSubmitter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("colSubmitter@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withSubmitterGroup(new EPerson[]{colSubmitter}).build();
        this.context.restoreAuthSystemState();
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        String tokenAdminCol = this.getAuthToken(adminCol1.getEmail(), this.password);
        String tokencolSubmitter = this.getAuthToken(colSubmitter.getEmail(), this.password);
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Rossi"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(adminChild1), EPersonMatcher.matchEPersonEntry(adminCol1), EPersonMatcher.matchEPersonEntry(colSubmitter)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Rossi"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(adminChild1), EPersonMatcher.matchEPersonEntry(adminCol1), EPersonMatcher.matchEPersonEntry(colSubmitter)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokencolSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Rossi"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByMetadataByCommAdminAndByColAdminWithoutAuthorizationsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        LinkedList<String> confPropsCollectionAdmins = new LinkedList<String>();
        confPropsCollectionAdmins.add("core.authorization.collection-admin.policies");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.workflows");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.submitters");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.admin-group");
        LinkedList<String> confPropsCommunityAdmins = new LinkedList<String>();
        confPropsCommunityAdmins.add("core.authorization.community-admin.policies");
        confPropsCommunityAdmins.add("core.authorization.community-admin.admin-group");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.policies");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.workflows");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.submitters");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.admin-group");
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson col1Submitter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("col1Submitter@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol}).withSubmitterGroup(new EPerson[]{col1Submitter}).build();
        this.context.restoreAuthSystemState();
        String tokenAdminCol = this.getAuthToken(adminCol.getEmail(), this.password);
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        for (String prop : confPropsCollectionAdmins) {
            this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Rossi"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(adminChild1), EPersonMatcher.matchEPersonEntry(adminCol), EPersonMatcher.matchEPersonEntry(col1Submitter)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
            this.configurationService.setProperty(prop, (Object)false);
        }
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Rossi"})).andExpect(MockMvcResultMatchers.status().isForbidden());
        for (String prop : confPropsCommunityAdmins) {
            this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Rossi"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EPersonMatcher.matchEPersonEntry(adminChild1), EPersonMatcher.matchEPersonEntry(adminCol), EPersonMatcher.matchEPersonEntry(col1Submitter)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
            this.configurationService.setProperty(prop, (Object)false);
        }
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Rossi"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void discoverableNestedLinkTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.epersons.href", (Matcher)Matchers.is((Object)"http://localhost/api/eperson/epersons")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.eperson-registration.href", (Matcher)Matchers.is((Object)"http://localhost/api/eperson/registrations")))));
    }

    @Test
    public void findByMetadataUsingFirstNamePaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").build();
        EPerson ePerson2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jane", "Smith").withEmail("janesmith@example.com").build();
        EPerson ePerson3 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Smith").withEmail("tomdoe@example.com").build();
        EPerson ePerson4 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John-Postfix", "Smath").withEmail("dirkdoepostfix@example.com").build();
        EPerson ePerson5 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Prefix-John", "Smoth").withEmail("harrydoeprefix@example.com").build();
        EPerson ePerson6 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Boychuk").withEmail("johnboychuk@example.com").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getFirstName()}).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getFirstName()}).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getFirstName()}).param("page", new String[]{"2"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{ePerson.getFirstName()}).param("page", new String[]{"3"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
    }
}

