/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.GroupMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class GroupRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private AuthorizeService authorizeService;
    Collection collection;

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("test").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTest() throws Exception {
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRefNoEmbeds = new AtomicReference();
        try {
            ObjectMapper mapper = new ObjectMapper();
            GroupRest groupRest = new GroupRest();
            GroupRest groupRestNoEmbeds = new GroupRest();
            String groupName = "testGroup1";
            String groupDescription = "test description";
            String groupNameNoEmbeds = "testGroup2";
            groupRest.setName(groupName);
            MetadataRest metadata = new MetadataRest();
            metadata.put("dc.description", new MetadataValueRest[]{new MetadataValueRest(groupDescription)});
            groupRest.setMetadata(metadata);
            groupRestNoEmbeds.setName(groupNameNoEmbeds);
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/groups", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchFullEmbeds())).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupWithName(groupName), GroupMatcher.matchGroupWithName("Administrator"), GroupMatcher.matchGroupWithName("Anonymous")})));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/groups", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRestNoEmbeds)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andDo(result -> idRefNoEmbeds.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
            Group group = (Group)groupService.find(this.context, (UUID)idRef.get());
            Assert.assertEquals((Object)groupService.getMetadata((DSpaceObject)group, "dc.description"), (Object)groupDescription);
        }
        finally {
            GroupBuilder.deleteGroup((UUID)((UUID)idRef.get()));
            GroupBuilder.deleteGroup((UUID)((UUID)idRefNoEmbeds.get()));
        }
    }

    @Test
    public void createUnauthauthorizedTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        String groupName = "testGroupUnauth1";
        groupRest.setName(groupName);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/groups", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void createForbiddenTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        String groupName = "testGroupForbidden1";
        groupRest.setName(groupName);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/groups", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createUnprocessableTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/groups", (Object[])new Object[0]).content("").contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"Unprocessable")));
    }

    @Test
    public void createWithoutNameTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.configurationService.setProperty("webui.supported.locales", (Object)"en, pl");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/groups", (Object[])new Object[0]).header("Accept-Language", new Object[]{"pl"}).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)I18nUtil.getMessage((String)"org.dspace.app.rest.exception.GroupNameNotProvidedException.message", (Locale)new Locale("pl"))))).andExpect(MockMvcResultMatchers.status().reason(Matchers.startsWith((String)"[PL]")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/groups", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity()).andExpect(MockMvcResultMatchers.status().reason(Matchers.is((Object)I18nUtil.getMessage((String)"org.dspace.app.rest.exception.GroupNameNotProvidedException.message")))).andExpect(MockMvcResultMatchers.status().reason(Matchers.not((Matcher)Matchers.startsWith((String)"[PL]"))));
    }

    @Test
    public void findAllTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupWithName("Administrator"), GroupMatcher.matchGroupWithName("Anonymous")})));
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String testGroupName = "Test group";
        Group group = GroupBuilder.createGroup((Context)this.context).withName(testGroupName).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String generatedGroupId = group.getID().toString();
        String groupIdCall = "/api/eperson/groups/" + generatedGroupId;
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)groupIdCall, (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchLinks(group.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(GroupMatcher.matchGroupEntry(group.getID(), group.getName()))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + generatedGroupId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds()));
    }

    @Test
    public void readGroupAuthorizationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("Group1").build();
        Group group2 = GroupBuilder.createGroup((Context)this.context).withName("Group2").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + group2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(GroupMatcher.matchGroupEntry(group2.getID(), group2.getName())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(GroupMatcher.matchGroupEntry(group.getID(), group.getName()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/groups/" + group2.getID()))));
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + group2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(GroupMatcher.matchGroupEntry(group2.getID(), group2.getName())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(GroupMatcher.matchGroupEntry(group.getID(), group.getName()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/groups/" + group2.getID()))));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group privateGroup = GroupBuilder.createGroup((Context)this.context).withName("Private Group").build();
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)privateGroup, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + privateGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneTestWrongUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String testGroupName = "Test group";
        Group group = GroupBuilder.createGroup((Context)this.context).withName(testGroupName).build();
        this.context.restoreAuthSystemState();
        String generatedGroupId = group.getID().toString();
        String groupIdCall = "/api/eperson/groups/" + UUID.randomUUID();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)groupIdCall, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void searchMethodsExist() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.search.href", (Matcher)Matchers.notNullValue()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/epersons/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.byMetadata", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void findByMetadata() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("Test group").build();
        Group group2 = GroupBuilder.createGroup((Context)this.context).withName("Test group 2").build();
        Group group3 = GroupBuilder.createGroup((Context)this.context).withName("Test group 3").build();
        Group group4 = GroupBuilder.createGroup((Context)this.context).withName("Test other group").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupEntry(group1.getID(), group1.getName()), GroupMatcher.matchGroupEntry(group2.getID(), group2.getName()), GroupMatcher.matchGroupEntry(group3.getID(), group3.getName())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{String.valueOf(group1.getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.contains(GroupMatcher.matchGroupEntry(group1.getID(), group1.getName())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByMetadataUnauthorized() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Administrator"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByMetadataForbidden() throws Exception {
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Administrator"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByMetadataUndefined() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"Non-existing Group"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByMetadataMissingParameter() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void patchGroupMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchGroupMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("Group").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/eperson/groups/" + group.getID(), expectedStatus);
    }

    @Test
    public void patchGroupName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("Group").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/name", (Object)"new name");
        ops.add((Operation)replaceOperation);
        String requestBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0]).content(requestBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(GroupMatcher.matchGroupEntry(group.getID(), "new name"))));
    }

    @Test
    public void patchGroupWithParentUnprocessable() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin, reviewer1}).build();
        Group workflowGroup = col1.getWorkflowStep1(this.context);
        String name = workflowGroup.getName();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/name", (Object)"new name");
        ops.add((Operation)replaceOperation);
        String requestBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/groups/" + workflowGroup.getID()), (Object[])new Object[0]).content(requestBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + workflowGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(GroupMatcher.matchGroupEntry(workflowGroup.getID(), name))));
    }

    @Test
    public void patchPermanentGroupUnprocessable() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group group = groupService.findByName(this.context, "Anonymous");
        String name = group.getName();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/name", (Object)"new name");
        ops.add((Operation)replaceOperation);
        String requestBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0]).content(requestBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(GroupMatcher.matchGroupEntry(group.getID(), name))));
    }

    @Test
    public void addChildGroupTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson member = EPersonBuilder.createEPerson((Context)this.context).build();
        Group parentGroup = GroupBuilder.createGroup((Context)this.context).build();
        Group parentGroupWithPreviousSubgroup = GroupBuilder.createGroup((Context)this.context).build();
        Group subGroup = GroupBuilder.createGroup((Context)this.context).withParent(parentGroupWithPreviousSubgroup).addMember(this.eperson).build();
        Group childGroup1 = GroupBuilder.createGroup((Context)this.context).addMember(member).build();
        Group childGroup2 = GroupBuilder.createGroup((Context)this.context).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + childGroup1.getID() + "/\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroupWithPreviousSubgroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + childGroup1.getID() + "/\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
        parentGroupWithPreviousSubgroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroupWithPreviousSubgroup);
        subGroup = (Group)this.context.reloadEntity((ReloadableEntity)subGroup);
        childGroup1 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup1);
        childGroup2 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup2);
        Assert.assertTrue((boolean)groupService.isMember(parentGroup, childGroup1));
        Assert.assertTrue((boolean)groupService.isMember(parentGroup, childGroup2));
        Assert.assertTrue((boolean)groupService.isMember(this.context, member, parentGroup));
        Assert.assertTrue((boolean)groupService.isMember(parentGroupWithPreviousSubgroup, childGroup1));
        Assert.assertTrue((boolean)groupService.isMember(parentGroupWithPreviousSubgroup, childGroup2));
        Assert.assertTrue((boolean)groupService.isMember(parentGroupWithPreviousSubgroup, subGroup));
        Assert.assertTrue((boolean)groupService.isMember(this.context, member, parentGroupWithPreviousSubgroup));
        Assert.assertTrue((boolean)groupService.isMember(this.context, this.eperson, parentGroupWithPreviousSubgroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addChildGroupCommunityAdminTest() throws Exception {
        CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Community community = null;
        Group parentGroup = null;
        Group childGroup1 = null;
        Group childGroup2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            community = communityService.create(null, this.context);
            parentGroup = communityService.createAdministrators(this.context, community);
            childGroup1 = groupService.create(this.context);
            childGroup2 = groupService.create(this.context);
            groupService.addMember(this.context, parentGroup, this.eperson);
            groupService.update(this.context, (DSpaceObject)parentGroup);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup1 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup1);
            childGroup2 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + childGroup1.getID() + "/\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup1 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup1);
            childGroup2 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup2);
            Assert.assertTrue((boolean)groupService.isMember(parentGroup, childGroup1));
            Assert.assertTrue((boolean)groupService.isMember(parentGroup, childGroup2));
        }
        finally {
            if (community != null) {
                CommunityBuilder.deleteCommunity((UUID)community.getID());
            }
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup1 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup1.getID());
            }
            if (childGroup2 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addChildGroupForbiddenTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup1 = null;
        Group childGroup2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup1 = groupService.create(this.context);
            childGroup2 = groupService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup1 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup1);
            childGroup2 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + childGroup1.getID() + "/\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup1 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup1.getID());
            }
            if (childGroup2 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addChildGroupUnauthorizedTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup1 = null;
        Group childGroup2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup1 = groupService.create(this.context);
            childGroup2 = groupService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup1 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup1);
            childGroup2 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup2);
            this.context.restoreAuthSystemState();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + childGroup1.getID() + "/\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup1 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup1.getID());
            }
            if (childGroup2 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addChildGroupNotFoundTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup1 = null;
        Group childGroup2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup1 = groupService.create(this.context);
            childGroup2 = groupService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup1 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup1);
            childGroup2 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + UUID.randomUUID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + childGroup1.getID() + "/\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isNotFound());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup1 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup1.getID());
            }
            if (childGroup2 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addChildGroupUnprocessableTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup1 = null;
        Group childGroup2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup1 = groupService.create(this.context);
            childGroup2 = groupService.create(this.context);
            groupService.addMember(this.context, childGroup1, parentGroup);
            groupService.update(this.context, (DSpaceObject)childGroup1);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup1 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup1);
            childGroup2 = (Group)this.context.reloadEntity((ReloadableEntity)childGroup2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/123456789\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + childGroup1.getID() + "/\nhttp://localhost/api/eperson/groups/" + childGroup2.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup1 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup1.getID());
            }
            if (childGroup2 != null) {
                GroupBuilder.deleteGroup((UUID)childGroup2.getID());
            }
        }
    }

    @Test
    public void addMemberTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        Group parentGroup = GroupBuilder.createGroup((Context)this.context).build();
        Group parentGroupWithPreviousMember = GroupBuilder.createGroup((Context)this.context).addMember(this.eperson).build();
        Group groupWithSubgroup = GroupBuilder.createGroup((Context)this.context).build();
        Group subGroup = GroupBuilder.createGroup((Context)this.context).withParent(groupWithSubgroup).build();
        EPerson member1 = EPersonBuilder.createEPerson((Context)this.context).build();
        EPerson member2 = EPersonBuilder.createEPerson((Context)this.context).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + member1.getID() + "/\nhttp://localhost/api/eperson/groups/" + member2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroupWithPreviousMember.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + member1.getID() + "/\nhttp://localhost/api/eperson/groups/" + member2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + subGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + member1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
        parentGroupWithPreviousMember = (Group)this.context.reloadEntity((ReloadableEntity)parentGroupWithPreviousMember);
        groupWithSubgroup = (Group)this.context.reloadEntity((ReloadableEntity)groupWithSubgroup);
        member1 = (EPerson)this.context.reloadEntity((ReloadableEntity)member1);
        member2 = (EPerson)this.context.reloadEntity((ReloadableEntity)member2);
        this.eperson = (EPerson)this.context.reloadEntity((ReloadableEntity)this.eperson);
        Assert.assertTrue((boolean)groupService.isMember(this.context, member1, parentGroup));
        Assert.assertTrue((boolean)groupService.isMember(this.context, member2, parentGroup));
        Assert.assertTrue((boolean)groupService.isMember(this.context, member1, parentGroupWithPreviousMember));
        Assert.assertTrue((boolean)groupService.isMember(this.context, member2, parentGroupWithPreviousMember));
        Assert.assertTrue((boolean)groupService.isMember(this.context, this.eperson, parentGroupWithPreviousMember));
        Assert.assertTrue((boolean)groupService.isMember(this.context, member1, groupWithSubgroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addMemberCommunityAdminTest() throws Exception {
        CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Community community = null;
        Group parentGroup = null;
        EPerson member1 = null;
        EPerson member2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            community = communityService.create(null, this.context);
            parentGroup = communityService.createAdministrators(this.context, community);
            member1 = ePersonService.create(this.context);
            member2 = ePersonService.create(this.context);
            groupService.addMember(this.context, parentGroup, this.eperson);
            groupService.update(this.context, (DSpaceObject)parentGroup);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member1 = (EPerson)this.context.reloadEntity((ReloadableEntity)member1);
            member2 = (EPerson)this.context.reloadEntity((ReloadableEntity)member2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + member1.getID() + "/\nhttp://localhost/api/eperson/groups/" + member2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member1 = (EPerson)this.context.reloadEntity((ReloadableEntity)member1);
            member2 = (EPerson)this.context.reloadEntity((ReloadableEntity)member2);
            Assert.assertTrue((boolean)groupService.isMember(this.context, member1, parentGroup));
            Assert.assertTrue((boolean)groupService.isMember(this.context, member2, parentGroup));
        }
        finally {
            if (community != null) {
                CommunityBuilder.deleteCommunity((UUID)community.getID());
            }
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member1 != null) {
                EPersonBuilder.deleteEPerson((UUID)member1.getID());
            }
            if (member2 != null) {
                EPersonBuilder.deleteEPerson((UUID)member2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addMemberForbiddenTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member1 = null;
        EPerson member2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member1 = ePersonService.create(this.context);
            member2 = ePersonService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member1 = (EPerson)this.context.reloadEntity((ReloadableEntity)member1);
            member2 = (EPerson)this.context.reloadEntity((ReloadableEntity)member2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + member1.getID() + "/\nhttp://localhost/api/eperson/groups/" + member2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member1 != null) {
                EPersonBuilder.deleteEPerson((UUID)member1.getID());
            }
            if (member2 != null) {
                EPersonBuilder.deleteEPerson((UUID)member2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addMemberUnauthorizedTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member1 = null;
        EPerson member2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member1 = ePersonService.create(this.context);
            member2 = ePersonService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member1 = (EPerson)this.context.reloadEntity((ReloadableEntity)member1);
            member2 = (EPerson)this.context.reloadEntity((ReloadableEntity)member2);
            this.context.restoreAuthSystemState();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + member1.getID() + "/\nhttp://localhost/api/eperson/groups/" + member2.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member1 != null) {
                EPersonBuilder.deleteEPerson((UUID)member1.getID());
            }
            if (member2 != null) {
                EPersonBuilder.deleteEPerson((UUID)member2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addMemberNotFoundTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member1 = null;
        EPerson member2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member1 = ePersonService.create(this.context);
            member2 = ePersonService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member1 = (EPerson)this.context.reloadEntity((ReloadableEntity)member1);
            member2 = (EPerson)this.context.reloadEntity((ReloadableEntity)member2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + UUID.randomUUID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + member1.getID() + "/\nhttp://localhost/api/eperson/groups/" + member2.getID())).andExpect(MockMvcResultMatchers.status().isNotFound());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member1 != null) {
                EPersonBuilder.deleteEPerson((UUID)member1.getID());
            }
            if (member2 != null) {
                EPersonBuilder.deleteEPerson((UUID)member2.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addMemberUnprocessableTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member1 = null;
        EPerson member2 = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member1 = ePersonService.create(this.context);
            member2 = ePersonService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member1 = (EPerson)this.context.reloadEntity((ReloadableEntity)member1);
            member2 = (EPerson)this.context.reloadEntity((ReloadableEntity)member2);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/123456789\nhttp://localhost/api/eperson/groups/" + member2.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member1 != null) {
                EPersonBuilder.deleteEPerson((UUID)member1.getID());
            }
            if (member2 != null) {
                EPersonBuilder.deleteEPerson((UUID)member2.getID());
            }
        }
    }

    @Test
    public void removeChildGroupTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        Group parentGroup = GroupBuilder.createGroup((Context)this.context).build();
        Group childGroup = GroupBuilder.createGroup((Context)this.context).withParent(parentGroup).build();
        Group childGroupWithMember = GroupBuilder.createGroup((Context)this.context).addMember(this.eperson).withParent(parentGroup).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups/" + childGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
        childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
        childGroupWithMember = (Group)this.context.reloadEntity((ReloadableEntity)childGroupWithMember);
        this.eperson = (EPerson)this.context.reloadEntity((ReloadableEntity)this.eperson);
        Assert.assertFalse((boolean)groupService.isMember(parentGroup, childGroup));
        Assert.assertTrue((boolean)groupService.isMember(parentGroup, childGroupWithMember));
        Assert.assertTrue((boolean)groupService.isMember(this.context, this.eperson, parentGroup));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups/" + childGroupWithMember.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
        childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
        childGroupWithMember = (Group)this.context.reloadEntity((ReloadableEntity)childGroupWithMember);
        this.eperson = (EPerson)this.context.reloadEntity((ReloadableEntity)this.eperson);
        Assert.assertFalse((boolean)groupService.isMember(parentGroup, childGroupWithMember));
        Assert.assertFalse((boolean)groupService.isMember(this.context, this.eperson, parentGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeChildGroupCommunityAdminTest() throws Exception {
        CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Community community = null;
        Group parentGroup = null;
        Group childGroup = null;
        try {
            this.context.turnOffAuthorisationSystem();
            community = communityService.create(null, this.context);
            parentGroup = communityService.createAdministrators(this.context, community);
            childGroup = groupService.create(this.context);
            groupService.addMember(this.context, parentGroup, childGroup);
            groupService.addMember(this.context, parentGroup, this.eperson);
            groupService.update(this.context, (DSpaceObject)parentGroup);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups/" + childGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
            Assert.assertFalse((boolean)groupService.isMember(parentGroup, childGroup));
        }
        finally {
            if (community != null) {
                CommunityBuilder.deleteCommunity((UUID)community.getID());
            }
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup != null) {
                GroupBuilder.deleteGroup((UUID)childGroup.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeChildGroupForbiddenTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup = groupService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups/" + childGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup != null) {
                GroupBuilder.deleteGroup((UUID)childGroup.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeChildGroupUnauthorizedTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup = groupService.create(this.context);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
            this.context.restoreAuthSystemState();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups/" + childGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup != null) {
                GroupBuilder.deleteGroup((UUID)childGroup.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeChildGroupNotFoundTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup = groupService.create(this.context);
            groupService.addMember(this.context, childGroup, parentGroup);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + UUID.randomUUID() + "/subgroups/" + childGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup != null) {
                GroupBuilder.deleteGroup((UUID)childGroup.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeChildGroupUnprocessableTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group parentGroup = null;
        Group childGroup = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            childGroup = groupService.create(this.context);
            groupService.addMember(this.context, childGroup, parentGroup);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            childGroup = (Group)this.context.reloadEntity((ReloadableEntity)childGroup);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/subgroups/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (childGroup != null) {
                GroupBuilder.deleteGroup((UUID)childGroup.getID());
            }
        }
    }

    @Test
    public void removeMemberTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson member = EPersonBuilder.createEPerson((Context)this.context).build();
        EPerson member2 = EPersonBuilder.createEPerson((Context)this.context).build();
        Group parentGroup = GroupBuilder.createGroup((Context)this.context).addMember(member).build();
        Group childGroup = GroupBuilder.createGroup((Context)this.context).withParent(parentGroup).addMember(member2).build();
        this.context.restoreAuthSystemState();
        Assert.assertTrue((boolean)groupService.isMember(this.context, member, parentGroup));
        Assert.assertTrue((boolean)groupService.isMember(this.context, member2, parentGroup));
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons/" + member.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + childGroup.getID() + "/epersons/" + member2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
        member = (EPerson)this.context.reloadEntity((ReloadableEntity)member);
        Assert.assertFalse((boolean)groupService.isMember(this.context, member, parentGroup));
        Assert.assertFalse((boolean)groupService.isMember(this.context, member2, parentGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeMemberCommunityAdminTest() throws Exception {
        CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Community community = null;
        Group parentGroup = null;
        EPerson member = null;
        try {
            this.context.turnOffAuthorisationSystem();
            community = communityService.create(null, this.context);
            parentGroup = communityService.createAdministrators(this.context, community);
            member = ePersonService.create(this.context);
            groupService.addMember(this.context, parentGroup, member);
            groupService.addMember(this.context, parentGroup, this.eperson);
            groupService.update(this.context, (DSpaceObject)parentGroup);
            Assert.assertTrue((boolean)groupService.isMember(this.context, member, parentGroup));
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member = (EPerson)this.context.reloadEntity((ReloadableEntity)member);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons/" + member.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member = (EPerson)this.context.reloadEntity((ReloadableEntity)member);
            Assert.assertFalse((boolean)groupService.isMember(this.context, member, parentGroup));
        }
        finally {
            if (community != null) {
                CommunityBuilder.deleteCommunity((UUID)community.getID());
            }
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member != null) {
                EPersonBuilder.deleteEPerson((UUID)member.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeMemberForbiddenTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member = ePersonService.create(this.context);
            groupService.addMember(this.context, parentGroup, member);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member = (EPerson)this.context.reloadEntity((ReloadableEntity)member);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons/" + member.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member != null) {
                EPersonBuilder.deleteEPerson((UUID)member.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeMemberUnauthorizedTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member = ePersonService.create(this.context);
            groupService.addMember(this.context, parentGroup, member);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member = (EPerson)this.context.reloadEntity((ReloadableEntity)member);
            this.context.restoreAuthSystemState();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons/" + member.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member != null) {
                EPersonBuilder.deleteEPerson((UUID)member.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeMemberNotFoundTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member = ePersonService.create(this.context);
            groupService.addMember(this.context, parentGroup, member);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member = (EPerson)this.context.reloadEntity((ReloadableEntity)member);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + UUID.randomUUID() + "/epersons/" + member.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member != null) {
                EPersonBuilder.deleteEPerson((UUID)member.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeMemberUnprocessableTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        Group parentGroup = null;
        EPerson member = null;
        try {
            this.context.turnOffAuthorisationSystem();
            parentGroup = groupService.create(this.context);
            member = ePersonService.create(this.context);
            groupService.addMember(this.context, parentGroup, member);
            this.context.commit();
            parentGroup = (Group)this.context.reloadEntity((ReloadableEntity)parentGroup);
            member = (EPerson)this.context.reloadEntity((ReloadableEntity)member);
            this.context.restoreAuthSystemState();
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID() + "/epersons/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            if (parentGroup != null) {
                GroupBuilder.deleteGroup((UUID)parentGroup.getID());
            }
            if (member != null) {
                EPersonBuilder.deleteEPerson((UUID)member.getID());
            }
        }
    }

    @Test
    public void deleteGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group parentGroup = GroupBuilder.createGroup((Context)this.context).withName("test group").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteGroupUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group parentGroup = GroupBuilder.createGroup((Context)this.context).withName("test group").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteGroupUnprocessableTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin, reviewer1}).build();
        Group workflowGroup = col1.getWorkflowStep1(this.context);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + workflowGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + workflowGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + workflowGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deletePermanentGroupUnprocessableTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        Group group = groupService.findByName(this.context, "Anonymous");
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group parentGroup = GroupBuilder.createGroup((Context)this.context).withName("test group").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + parentGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteGroupNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getGroupObjectCommunityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.admin}).build();
        Group adminGroup = community.getAdministrators();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/object"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getGroupObjectCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.admin}).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withAdminGroup(new EPerson[]{this.admin}).withWorkflowGroup(1, new EPerson[]{this.admin}).withSubmitterGroup(new EPerson[]{this.admin}).build();
        Group adminGroup = collection.getAdministrators();
        Group worfklowGroup = collection.getWorkflowStep1(this.context);
        Group submitterGroup = collection.getSubmitters();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/object"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + worfklowGroup.getID() + "/object"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + submitterGroup.getID() + "/object"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getGroupObjectNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = GroupBuilder.createGroup((Context)this.context).withName("test group").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/object"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void getGroupObjectUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.admin}).build();
        Group adminGroup = community.getAdministrators();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/object"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchNameTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String testGroupName = "Test group";
        Group group = GroupBuilder.createGroup((Context)this.context).withName(testGroupName).build();
        this.context.restoreAuthSystemState();
        String newName = "New test name";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/name", (Object)newName);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)newName))).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findByMetadataByCommAdminAndByColAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson colSubmitter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("colSubmitter@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withSubmitterGroup(new EPerson[]{colSubmitter}).build();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("Test group").build();
        Group group2 = GroupBuilder.createGroup((Context)this.context).withName("Test group 2").build();
        Group group3 = GroupBuilder.createGroup((Context)this.context).withName("Test group 3").build();
        Group group4 = GroupBuilder.createGroup((Context)this.context).withName("Test other group").build();
        this.context.restoreAuthSystemState();
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        String tokenAdminCol = this.getAuthToken(adminCol1.getEmail(), this.password);
        String tokenSubmitterCol = this.getAuthToken(colSubmitter.getEmail(), this.password);
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupEntry(group1.getID(), group1.getName()), GroupMatcher.matchGroupEntry(group2.getID(), group2.getName()), GroupMatcher.matchGroupEntry(group3.getID(), group3.getName())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupEntry(group1.getID(), group1.getName()), GroupMatcher.matchGroupEntry(group2.getID(), group2.getName()), GroupMatcher.matchGroupEntry(group3.getID(), group3.getName())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenSubmitterCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByMetadataByCommAdminAndByColAdminWithoutAuthorizationsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        LinkedList<String> confPropsCollectionAdmins = new LinkedList<String>();
        confPropsCollectionAdmins.add("core.authorization.collection-admin.policies");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.submitters");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.workflows");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.admin-group");
        LinkedList<String> confPropsCommunityAdmins = new LinkedList<String>();
        confPropsCommunityAdmins.add("core.authorization.community-admin.policies");
        confPropsCommunityAdmins.add("core.authorization.community-admin.admin-group");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.policies");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.workflows");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.submitters");
        confPropsCommunityAdmins.add("core.authorization.community-admin.collection.admin-group");
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).build();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("Test group").build();
        Group group2 = GroupBuilder.createGroup((Context)this.context).withName("Test group 2").build();
        Group group3 = GroupBuilder.createGroup((Context)this.context).withName("Test group 3").build();
        Group group4 = GroupBuilder.createGroup((Context)this.context).withName("Test other group").build();
        this.context.restoreAuthSystemState();
        String tokenAdminCol = this.getAuthToken(adminCol1.getEmail(), this.password);
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        for (String prop : confPropsCollectionAdmins) {
            this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupEntry(group1.getID(), group1.getName()), GroupMatcher.matchGroupEntry(group2.getID(), group2.getName()), GroupMatcher.matchGroupEntry(group3.getID(), group3.getName())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
            this.configurationService.setProperty(prop, (Object)false);
        }
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        for (String prop : confPropsCommunityAdmins) {
            this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{GroupMatcher.matchGroupEntry(group1.getID(), group1.getName()), GroupMatcher.matchGroupEntry(group2.getID(), group2.getName()), GroupMatcher.matchGroupEntry(group3.getID(), group3.getName())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
            this.configurationService.setProperty(prop, (Object)false);
        }
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{group1.getName()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void commAdminManageOwnerAdminGroupTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("submitter1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Group groupAdmins = child1.getAdministrators();
        this.context.restoreAuthSystemState();
        String tokenCommAdmin = this.getAuthToken(adminChild1.getEmail(), this.password);
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, groupAdmins));
        this.getClient(tokenCommAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + groupAdmins.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, groupAdmins));
        this.getClient(tokenCommAdmin).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + groupAdmins.getID() + "/epersons/" + submitter1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, groupAdmins));
    }

    @Test
    public void colAdminManageSubmitterGroupAndAdminGroupTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("submitter1@example.com").withPassword(this.password).build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Robert", "Clarks").withEmail("submitter2@example.com").withPassword(this.password).build();
        EPerson submitter3 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jack", "Brown").withEmail("submitter3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Group groupSubmitters = col1.getSubmitters();
        Group groupAdmins = col1.getAdministrators();
        this.context.restoreAuthSystemState();
        String tokenAdminCol = this.getAuthToken(adminCol1.getEmail(), this.password);
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, groupSubmitters));
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, groupSubmitters));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + groupSubmitters.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID() + "/\nhttp://localhost/api/eperson/groups/" + submitter2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, groupSubmitters));
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter2, groupSubmitters));
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter3, groupAdmins));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + groupAdmins.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter3.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter3, groupAdmins));
    }

    @Test
    public void colAdminWithoutRightsTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        LinkedList<String> confPropsCollectionAdmins = new LinkedList<String>();
        confPropsCollectionAdmins.add("core.authorization.collection-admin.policies");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.submitters");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.workflows");
        confPropsCollectionAdmins.add("core.authorization.collection-admin.admin-group");
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("submitter1@example.com").withPassword(this.password).build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Robert", "Clarks").withEmail("submitter2@example.com").withPassword(this.password).build();
        EPerson submitter3 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jack", "Brown").withEmail("submitter3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withSubmitterGroup(new EPerson[]{submitter2}).build();
        Group groupSubmitters = col1.getSubmitters();
        this.context.restoreAuthSystemState();
        String tokenAdminCol = this.getAuthToken(adminCol1.getEmail(), this.password);
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, groupSubmitters));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + groupSubmitters.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, groupSubmitters));
        for (String prop : confPropsCollectionAdmins) {
            this.configurationService.setProperty(prop, (Object)false);
        }
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter3, groupSubmitters));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + groupSubmitters.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter3.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter3, groupSubmitters));
    }

    @Test
    public void communityAdminCanManageCollectionSubmittersGroupAndAdminsGroupsTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("submitter1@example.com").withPassword(this.password).build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Robert", "Clarks").withEmail("submitter2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Group groupSubmitters = col1.getSubmitters();
        Group groupAdministrators = col1.getAdministrators();
        this.context.restoreAuthSystemState();
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, groupSubmitters));
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, groupSubmitters));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + groupSubmitters.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID() + "/\nhttp://localhost/api/eperson/groups/" + submitter2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, groupSubmitters));
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter2, groupSubmitters));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + groupSubmitters.getID() + "/epersons/" + submitter1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, groupSubmitters));
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter2, groupSubmitters));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + groupAdministrators.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, groupAdministrators));
        Assert.assertTrue((boolean)groupService.isMember(this.context, adminCol1, groupAdministrators));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + groupAdministrators.getID() + "/epersons/" + adminCol1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, adminCol1, groupAdministrators));
    }

    @Test
    public void commAdminAndColAdminCanManageItemReadGroupTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("submitter1@example.com").withPassword(this.password).build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Robert", "Clarks").withEmail("submitter2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withSubmitterGroup(new EPerson[]{this.eperson}).build();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        Group itemReadGroup = this.collectionService.createDefaultReadGroup(this.context, col1, itemGroupString, defaultItemRead);
        this.context.restoreAuthSystemState();
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        String tokenAdminCol = this.getAuthToken(adminChild1.getEmail(), this.password);
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, itemReadGroup));
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, itemReadGroup));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + itemReadGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, itemReadGroup));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + itemReadGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter2, itemReadGroup));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + itemReadGroup.getID() + "/epersons/" + submitter2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, itemReadGroup));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + itemReadGroup.getID() + "/epersons/" + submitter1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, itemReadGroup));
    }

    @Test
    public void commAdminAndColAdminCanManageBitstreamReadGroupTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("submitter1@example.com").withPassword(this.password).build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Robert", "Clarks").withEmail("submitter2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withSubmitterGroup(new EPerson[]{this.eperson}).build();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        Group bitstreamReadGroup = this.collectionService.createDefaultReadGroup(this.context, col1, bitstreamGroupString, defaultBitstreamRead);
        this.context.restoreAuthSystemState();
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        String tokenAdminCol = this.getAuthToken(adminChild1.getEmail(), this.password);
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, bitstreamReadGroup));
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, bitstreamReadGroup));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + bitstreamReadGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, bitstreamReadGroup));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + bitstreamReadGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter2, bitstreamReadGroup));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + bitstreamReadGroup.getID() + "/epersons/" + submitter2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, bitstreamReadGroup));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + bitstreamReadGroup.getID() + "/epersons/" + submitter1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, bitstreamReadGroup));
    }

    @Test
    public void commAdminAndColAdminCanManageWorkflowGroupsTest() throws Exception {
        GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
        this.context.turnOffAuthorisationSystem();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Oliver", "Rossi").withEmail("adminChild1@example.com").withPassword(this.password).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("James", "Rossi").withEmail("adminCol1@example.com").withPassword(this.password).build();
        EPerson submitter1 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Carl", "Rossi").withEmail("submitter1@example.com").withPassword(this.password).build();
        EPerson submitter2 = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Robert", "Clarks").withEmail("submitter2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).withWorkflowGroup(1, new EPerson[]{this.eperson}).withWorkflowGroup(2, new EPerson[]{this.eperson}).build();
        Group workflowGroupStep1 = col1.getWorkflowStep1(this.context);
        Group workflowGroupStep2 = col1.getWorkflowStep2(this.context);
        this.context.restoreAuthSystemState();
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, workflowGroupStep1));
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, workflowGroupStep2));
        String tokenAdminComm = this.getAuthToken(adminChild1.getEmail(), this.password);
        String tokenAdminCol = this.getAuthToken(adminChild1.getEmail(), this.password);
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + workflowGroupStep1.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter1.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter1, workflowGroupStep1));
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + workflowGroupStep2.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + submitter2.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)groupService.isMember(this.context, submitter2, workflowGroupStep2));
        this.getClient(tokenAdminComm).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + workflowGroupStep2.getID() + "/epersons/" + submitter2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(tokenAdminCol).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + workflowGroupStep1.getID() + "/epersons/" + submitter1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter1, workflowGroupStep1));
        Assert.assertFalse((boolean)groupService.isMember(this.context, submitter2, workflowGroupStep2));
    }

    @Test
    public void collectionAdminRemoveMembersFromCollectionAdminGroupSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("testToAdd@test.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/epersons/" + ePerson.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail()))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.not((Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail())))));
    }

    @Test
    public void collectionAdminAddChildGroupToCollectionAdminGroupSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
    }

    @Test
    public void collectionAdminRemoveChildGroupFromCollectionAdminGroupSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.not((Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName())))));
    }

    @Test
    public void collectionAdminAddMembersToCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("testToAdd@test.com").build();
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/epersons/" + ePerson.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.not((Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail())))));
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)true);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)true);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void collectionAdminRemoveMembersFromCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("testToAdd@test.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/epersons/" + ePerson.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail()))));
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail()))));
    }

    @Test
    public void collectionAdminAddChildGroupToCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.not((Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName())))));
    }

    @Test
    public void collectionAdminRemoveChildGroupFromCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
    }

    @Test
    public void findByMetadataPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("Test group").build();
        Group group2 = GroupBuilder.createGroup((Context)this.context).withName("Test group 2").build();
        Group group3 = GroupBuilder.createGroup((Context)this.context).withName("Test group 3").build();
        Group group4 = GroupBuilder.createGroup((Context)this.context).withName("Test group 4").build();
        Group group5 = GroupBuilder.createGroup((Context)this.context).withName("Test other group").build();
        this.context.restoreAuthSystemState();
        String authTokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authTokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"group"}).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"group"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(authTokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"group"}).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"group"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
        this.getClient(authTokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/groups/search/byMetadata", (Object[])new Object[0]).param("query", new String[]{"group"}).param("page", new String[]{"2"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"group"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.groups", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5)));
    }
}

