/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.EntityTypeMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.matcher.RelationshipMatcher;
import org.dspace.app.rest.matcher.RelationshipTypeMatcher;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RelationshipTypeRestControllerIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EntityTypeService entityTypeService;

    @Test
    public void findAllEntityTypes() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntryForLabel("Publication"), EntityTypeMatcher.matchEntityTypeEntryForLabel("Person"), EntityTypeMatcher.matchEntityTypeEntryForLabel("Project"), EntityTypeMatcher.matchEntityTypeEntryForLabel("OrgUnit"), EntityTypeMatcher.matchEntityTypeEntryForLabel("Journal"), EntityTypeMatcher.matchEntityTypeEntryForLabel("JournalVolume"), EntityTypeMatcher.matchEntityTypeEntryForLabel("JournalIssue")})));
    }

    @Test
    public void findAllRelationshipTypesForPublications() throws Exception {
        EntityType publicationEntityType = this.entityTypeService.findByEntityType(this.context, "Publication");
        EntityType personEntityType = this.entityTypeService.findByEntityType(this.context, "Person");
        EntityType projectEntityType = this.entityTypeService.findByEntityType(this.context, "Project");
        EntityType orgunitEntityType = this.entityTypeService.findByEntityType(this.context, "OrgUnit");
        EntityType journalIssueEntityType = this.entityTypeService.findByEntityType(this.context, "journalIssue");
        RelationshipType relationshipType1 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publicationEntityType, personEntityType, "isAuthorOfPublication", "isPublicationOfAuthor");
        RelationshipType relationshipType2 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publicationEntityType, projectEntityType, "isProjectOfPublication", "isPublicationOfProject");
        RelationshipType relationshipType3 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publicationEntityType, orgunitEntityType, "isOrgUnitOfPublication", "isPublicationOfOrgUnit");
        RelationshipType relationshipType4 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, journalIssueEntityType, publicationEntityType, "isPublicationOfJournalIssue", "isJournalIssueOfPublication");
        RelationshipType relationshipType5 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publicationEntityType, orgunitEntityType, "isAuthorOfPublication", "isPublicationOfAuthor");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/entitytypes/" + publicationEntityType.getID() + "/relationshiptypes"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationshiptypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType1), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType2), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType3), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType4), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType5)})));
    }

    @Test
    public void createAndFindRelationships() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("OrgUnits").build();
        Item author1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withEntityType("Person").build();
        Item author2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Author2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withEntityType("Person").build();
        Item author3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Author3").withIssueDate("2016-02-13").withAuthor("Maybe, Maybe").withEntityType("Person").build();
        Item orgUnit1 = ItemBuilder.createItem((Context)this.context, (Collection)col3).withTitle("OrgUnit1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").withEntityType("OrgUnit").build();
        Item project1 = ItemBuilder.createItem((Context)this.context, (Collection)col3).withTitle("Project1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").withEntityType("Project").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)col3).withTitle("Publication1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").withEntityType("Publication").build();
        Item publication2 = ItemBuilder.createItem((Context)this.context, (Collection)col3).withTitle("Publication2").withIssueDate("2015-01-01").withEntityType("Publication").build();
        RelationshipType isOrgUnitOfPersonRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Person"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isOrgUnitOfPerson", "isPersonOfOrgUnit");
        RelationshipType isOrgUnitOfProjectRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Project"), this.entityTypeService.findByEntityType(this.context, "OrgUnit"), "isOrgUnitOfProject", "isProjectOfOrgUnit");
        RelationshipType isAuthorOfPublicationRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)publication, (Item)author1, (RelationshipType)isAuthorOfPublicationRelationshipType).build();
        Relationship relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)publication, (Item)author2, (RelationshipType)isAuthorOfPublicationRelationshipType).build();
        Relationship relationship3 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)publication2, (Item)author2, (RelationshipType)isAuthorOfPublicationRelationshipType).build();
        Relationship relationship4 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)publication2, (Item)author3, (RelationshipType)isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel?label=isAuthorOfPublication", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship1), RelationshipMatcher.matchRelationship(relationship2), RelationshipMatcher.matchRelationship(relationship3), RelationshipMatcher.matchRelationship(relationship4)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationships/search/byLabel?label=isAuthorOfPublication&size=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/search/byLabel?label=isAuthorOfPublication&dso=" + publication.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship1), RelationshipMatcher.matchRelationship(relationship2)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/search/byLabel?label=isAuthorOfPublication&dso=" + publication.getID() + "&size=1"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/search/byLabel?label=isAuthorOfPublication&dso=" + publication2.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipMatcher.matchRelationship(relationship3), RelationshipMatcher.matchRelationship(relationship4)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/search/byLabel?label=isAuthorOfPublication&dso=" + publication2.getID() + "&size=1"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }
}

