/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.Date;
import org.dspace.app.rest.matcher.VersionHistoryMatcher;
import org.dspace.app.rest.matcher.VersionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class VersionHistoryRestRepositoryIT
extends AbstractControllerIntegrationTest {
    VersionHistory versionHistory;
    Item item;
    Version version;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private VersionHistoryService versionHistoryService;
    @Autowired
    private VersioningService versioningService;

    @Before
    public void setup() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.versionHistory = (VersionHistory)this.versionHistoryService.create(this.context);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.version = this.versioningService.createNewVersion(this.context, this.versionHistory, this.item, "test", new Date(), 0);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findOneTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.is(VersionHistoryMatcher.matchEntry(this.versionHistory))));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)true);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)false);
    }

    @Test
    public void findOneWrongIDTest() throws Exception {
        int wrongVersionHistoryId = (this.versionHistory.getID() + 5) * 57;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + wrongVersionHistoryId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findVersionsOneWrongIDTest() throws Exception {
        int wrongVersionHistoryId = (this.versionHistory.getID() + 5) * 57;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + wrongVersionHistoryId + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findVersionsOfVersionHistoryTest() throws Exception {
        Version version = this.versionHistoryService.getFirstVersion(this.context, this.versionHistory);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(version))));
        this.context.turnOffAuthorisationSystem();
        Version secondVersion = this.versioningService.createNewVersion(this.context, this.versionHistory, this.item, "test", new Date(), 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VersionMatcher.matchEntry(version), VersionMatcher.matchEntry(secondVersion)})));
    }

    @Test
    public void findVersionsOfVersionHistoryPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Version version = this.versionHistoryService.getFirstVersion(this.context, this.versionHistory);
        Version secondVersion = this.versioningService.createNewVersion(this.context, this.versionHistory, this.item, "test", new Date(), 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"), (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(secondVersion)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.not((Matcher)Matchers.contains(VersionMatcher.matchEntry(version)))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"), (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.not((Matcher)Matchers.contains(VersionMatcher.matchEntry(secondVersion)))));
    }
}

