/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class DownloadFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private BitstreamConverter bitstreamConverter;
    @Autowired
    private Utils utils;
    private AuthorizationFeature downloadFeature;
    private Collection collectionA;
    private Item itemA;
    private Bitstream bitstreamA;
    private Bitstream bitstreamB;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.downloadFeature = this.authorizationFeatureService.find("canDownload");
        String bitstreamContent = "Dummy content";
        Community communityA = CommunityBuilder.createCommunity((Context)this.context).build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)communityA).withLogo("Blub").build();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).build();
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstreamA = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemA, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstreamB = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemA, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bitstreamB, 0);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void downloadOfCollectionAAsAdmin() throws Exception {
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionA, Projection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void downloadOfItemAAsAdmin() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void downloadOfBitstreamAAsAdmin() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(this.admin, this.downloadFeature, (BaseObjectRest)bitstreamRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is((Matcher)AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void downloadOfBitstreamBAsAdmin() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(this.admin, this.downloadFeature, (BaseObjectRest)bitstreamRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is((Matcher)AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void downloadOfCollectionAAsAnonymous() throws Exception {
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionA, Projection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void downloadOfItemAAsAnonymous() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void downloadOfBitstreamAAsAnonymous() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(null, this.downloadFeature, (BaseObjectRest)bitstreamRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is((Matcher)AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void downloadOfBitstreamBAsAnonymous() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void downloadOfCollectionAAsEperson() throws Exception {
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionA, Projection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void downloadOfItemAAsEperson() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void downloadOfBitstreamAAsEperson() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(this.eperson, this.downloadFeature, (BaseObjectRest)bitstreamRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is((Matcher)AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void downloadOfBitstreamBAsEperson() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.downloadFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }
}

