/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ManageMappedItemsFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private Utils utils;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private BitstreamConverter bitstreamConverter;
    private Community communityA;
    private Collection collectionA;
    private CollectionRest collectionARest;
    private Item itemA;
    private Bitstream bitstreamA;
    private BitstreamRest bitstreamARest;
    private Bundle bundleA;
    final String feature = "canManageMappedItems";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("collectionA").build();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("itemA").build();
        this.bundleA = BundleBuilder.createBundle((Context)this.context, (Item)this.itemA).withName("ORIGINAL").build();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstreamA = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)this.bundleA, (InputStream)is).withName("bistreamA").build();
        }
        this.context.restoreAuthSystemState();
        this.collectionARest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionA, Projection.DEFAULT);
        this.bitstreamARest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
    }

    @Test
    public void adminCollectionAdminSuccess() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappedItems"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void epersonCollectionNotFound() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappedItems"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void addWriteEpersonCollectionSuccess() throws Exception {
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionA).withAction(3).withUser(this.eperson).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionA).withAction(1).withUser(this.eperson).build();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappedItems"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void adminEpersonCollectionSuccess() throws Exception {
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionA).withAction(11).withUser(this.eperson).build();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappedItems"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void anonymousCollectionNotFound() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappedItems"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void adminBitstreamNotFound() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappedItems"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.bitstreamARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }
}

