/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.csv;

import com.google.gson.Gson;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ProcessStatus;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CsvExportIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void metadataExportTestWithoutFileParameterSucceeds() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("OrgUnits").build();
        Item article = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Article").withIssueDate("2017-10-17").withEntityType("Publication").build();
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", col1.getHandle()));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/system/scripts/metadata-export/processes", (Object[])new Object[0]).param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("metadata-export", String.valueOf(this.admin.getID()), parameters, ProcessStatus.COMPLETED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            String string = "";
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void metadataExportTestWithFileParameterFails() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("OrgUnits").build();
        Item article = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Article").withIssueDate("2017-10-17").withEntityType("Publication").build();
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-f", "test.csv"));
        parameters.add(new DSpaceCommandLineParameter("-i", col1.getHandle()));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/system/scripts/metadata-export/processes", (Object[])new Object[0]).param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("metadata-export", String.valueOf(this.admin.getID()), parameters, ProcessStatus.FAILED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            String string = "";
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }
}

