/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.content.Item;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ItemMatcher {
    private ItemMatcher() {
    }

    public static Matcher<? super Object> matchItemWithTitleAndDateIssued(Item item, String title, String dateIssued) {
        return Matchers.allOf(ItemMatcher.matchItemProperties(item), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.title", title), MetadataMatcher.matchMetadata("dc.date.issued", dateIssued))), ItemMatcher.matchLinks(item.getID()));
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("bundles[]", "mappedCollections[]", "owningCollection", "version", "relationships[]", "templateItemOf");
    }

    public static Matcher<? super Object> matchLinks(UUID uuid) {
        return HalMatcher.matchLinks("http://localhost/api/core/items/" + uuid, "bundles", "mappedCollections", "owningCollection", "relationships", "self", "version", "templateItemOf");
    }

    public static Matcher<? super Object> matchItemProperties(Item item) {
        return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)item.getName())), JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)item.getHandle())), JsonPathMatchers.hasJsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)item.isArchived())), JsonPathMatchers.hasJsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)item.isDiscoverable())), JsonPathMatchers.hasJsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)item.isWithdrawn())), JsonPathMatchers.hasJsonPath((String)"$.lastModified", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item"))});
    }
}

