/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.app.rest.matcher.EntityTypeMatcher;
import org.dspace.content.EntityType;
import org.dspace.content.RelationshipType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RelationshipTypeMatcher {
    private RelationshipTypeMatcher() {
    }

    public static Matcher<? super Object> matchRelationshipTypeEntry(RelationshipType relationshipType) {
        return RelationshipTypeMatcher.matchRelationshipTypeExplicitEntityTypes(relationshipType, relationshipType.getLeftType(), relationshipType.getRightType());
    }

    private static Matcher<? super Object> matchRelationshipTypeExplicitEntityTypes(RelationshipType relationshipType, EntityType leftType, EntityType rightType) {
        return RelationshipTypeMatcher.matchRelationshipTypeExplicitEntityTypeValues(relationshipType, leftType.getID(), leftType.getLabel(), rightType.getID(), rightType.getLabel());
    }

    private static Matcher<? super Object> matchRelationshipTypeExplicitEntityTypeValues(RelationshipType relationshipType, int leftEntityTypeId, String leftEntityTypeLabel, int rightEntityTypeId, String rightEntityTypeLabel) {
        return RelationshipTypeMatcher.matchExplicitRelationshipTypeValuesAndExplicitEntityTypeValues(relationshipType.getID(), relationshipType.getLeftwardType(), relationshipType.getRightwardType(), relationshipType.getLeftMinCardinality(), relationshipType.getLeftMaxCardinality(), relationshipType.getRightMinCardinality(), relationshipType.getRightMaxCardinality(), leftEntityTypeId, leftEntityTypeLabel, rightEntityTypeId, rightEntityTypeLabel, relationshipType.isCopyToLeft(), relationshipType.isCopyToRight());
    }

    private static Matcher<? super Object> matchExplicitRelationshipTypeValuesAndExplicitEntityType(int id, String leftwardType, String rightwardType, Integer leftMinCardinality, Integer leftMaxCardinality, Integer rightMinCardinality, Integer rightMaxCardinality, EntityType leftEntityType, EntityType rightEntityType, boolean copyToLeft, boolean copyToRight) {
        return RelationshipTypeMatcher.matchExplicitRelationshipTypeValuesAndExplicitEntityTypeValues(id, leftwardType, rightwardType, leftMinCardinality, leftMaxCardinality, rightMinCardinality, rightMaxCardinality, leftEntityType.getID(), leftEntityType.getLabel(), rightEntityType.getID(), rightEntityType.getLabel(), copyToLeft, copyToRight);
    }

    private static Matcher<? super Object> matchExplicitRelationshipTypeValuesAndExplicitEntityTypeValues(int id, String leftwardType, String rightwardType, Integer leftMinCardinality, Integer leftMaxCardinality, Integer rightMinCardinality, Integer rightMaxCardinality, int leftEntityTypeId, String leftEntityTypeLabel, int rightEntityTypeId, String rightEntityTypeLabel, boolean copyToLeft, boolean copyToRight) {
        return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)id)), JsonPathMatchers.hasJsonPath((String)"$.leftwardType", (Matcher)Matchers.is((Object)leftwardType)), JsonPathMatchers.hasJsonPath((String)"$.rightwardType", (Matcher)Matchers.is((Object)rightwardType)), JsonPathMatchers.hasJsonPath((String)"$.copyToLeft", (Matcher)Matchers.is((Object)copyToLeft)), JsonPathMatchers.hasJsonPath((String)"$.copyToRight", (Matcher)Matchers.is((Object)copyToRight)), JsonPathMatchers.hasJsonPath((String)"$.leftMinCardinality", (Matcher)Matchers.is((Object)leftMinCardinality)), JsonPathMatchers.hasJsonPath((String)"$.leftMaxCardinality", (Matcher)Matchers.is((Object)leftMaxCardinality)), JsonPathMatchers.hasJsonPath((String)"$.rightMinCardinality", (Matcher)Matchers.is((Object)rightMinCardinality)), JsonPathMatchers.hasJsonPath((String)"$.rightMaxCardinality", (Matcher)Matchers.is((Object)rightMaxCardinality)), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"relationshiptype")), JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/relationshiptypes/" + id))), JsonPathMatchers.hasJsonPath((String)"$._embedded.leftType", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeExplicitValuesEntry(leftEntityTypeId, leftEntityTypeLabel)})), JsonPathMatchers.hasJsonPath((String)"$._embedded.rightType", (Matcher)Matchers.is(EntityTypeMatcher.matchEntityTypeExplicitValuesEntry(rightEntityTypeId, rightEntityTypeLabel)))});
    }
}

