/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.security.jwt.SpecialGroupClaimProvider;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpecialGroupClaimProviderTest {
    @InjectMocks
    private SpecialGroupClaimProvider specialGroupClaimProvider;
    private List<UUID> specialGroups = new ArrayList<UUID>();
    private Context context;
    private String id1 = "02af436f-a531-4934-9b36-a21cd8fdcc57";
    private String id2 = "f39d3947-c75d-4d09-86ef-f732cfae7d88";
    private String id3 = "2262d8ad-8bb6-4330-9cee-06da30f3feae";
    @Mock
    private HttpServletRequest httpServletRequest;
    private JWTClaimsSet jwtClaimsSet;

    @Before
    public void setUp() throws Exception {
        this.context = (Context)Mockito.mock(Context.class);
        ((Context)Mockito.doAnswer(invocation -> {
            UUID uuid = (UUID)invocation.getArgument(0);
            this.specialGroups.add(uuid);
            return "done";
        }).when((Object)this.context)).setSpecialGroup((UUID)ArgumentMatchers.any(UUID.class));
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add(this.id1);
        groupIds.add(this.id2);
        groupIds.add(this.id3);
        this.jwtClaimsSet = new JWTClaimsSet.Builder().claim("sg", groupIds).build();
    }

    @After
    public void tearDown() throws Exception {
        this.specialGroups.clear();
    }

    @Test
    public void parseClaim() throws Exception {
        this.specialGroupClaimProvider.parseClaim(this.context, this.httpServletRequest, this.jwtClaimsSet);
        Assert.assertThat(this.specialGroups, (Matcher)Matchers.containsInAnyOrder((Object[])new UUID[]{UUID.fromString(this.id1), UUID.fromString(this.id2), UUID.fromString(this.id3)}));
    }
}

