/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.rest.Application;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.utils.DSpaceConfigurationInitializer;
import org.dspace.app.rest.utils.DSpaceKernelInitializer;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.servlet.support.ErrorPageFilter;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.hateoas.MediaTypes;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Application.class})
@ContextConfiguration(initializers={DSpaceKernelInitializer.class, DSpaceConfigurationInitializer.class})
@WebAppConfiguration
public class AbstractControllerIntegrationTest
extends AbstractIntegrationTestWithDatabase {
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String AUTHORIZATION_COOKIE = "Authorization-cookie";
    protected static final String AUTHORIZATION_TYPE = "Bearer ";
    public static final String REST_SERVER_URL = "http://localhost/api/";
    public static final String BASE_REST_SERVER_URL = "http://localhost";
    protected MediaType contentType = new MediaType(MediaTypes.HAL_JSON.getType(), MediaTypes.HAL_JSON.getSubtype());
    protected MediaType textUriContentType = RestMediaTypes.TEXT_URI_LIST;
    protected HttpMessageConverter mappingJackson2HttpMessageConverter;
    @Autowired
    private WebApplicationContext webApplicationContext;
    @Autowired
    private List<Filter> requestFilters;

    @Autowired
    void setConverters(HttpMessageConverter<?>[] converters) {
        this.mappingJackson2HttpMessageConverter = Arrays.asList(converters).stream().filter(hmc -> hmc instanceof MappingJackson2HttpMessageConverter).findAny().get();
        Assert.assertNotNull((String)"the JSON message converter must not be null", (Object)this.mappingJackson2HttpMessageConverter);
    }

    public MockMvc getClient() throws SQLException {
        return this.getClient(null);
    }

    public MockMvc getClient(String authToken) throws SQLException {
        if (this.context != null && this.context.isValid()) {
            this.context.commit();
        }
        DefaultMockMvcBuilder mockMvcBuilder = (DefaultMockMvcBuilder)((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).alwaysDo(MockMvcResultHandlers.print())).addFilters(new Filter[]{new ErrorPageFilter()})).addFilters(this.requestFilters.toArray(new Filter[this.requestFilters.size()]))).apply(SecurityMockMvcConfigurers.springSecurity());
        if (StringUtils.isNotBlank((CharSequence)authToken)) {
            mockMvcBuilder.defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf().asHeader()).header(AUTHORIZATION_HEADER, new Object[]{AUTHORIZATION_TYPE + authToken}));
        } else {
            mockMvcBuilder.defaultRequest((RequestBuilder)MockMvcRequestBuilders.get((String)"/", (Object[])new Object[0]).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf().asHeader()));
        }
        return mockMvcBuilder.build();
    }

    public MockHttpServletResponse getAuthResponse(String user, String password) throws Exception {
        return this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{user}).param("password", new String[]{password})).andReturn().getResponse();
    }

    public MockHttpServletResponse getAuthResponseWithXForwardedForHeader(String user, String password, String xForwardedFor) throws Exception {
        return this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/login", (Object[])new Object[0]).param("user", new String[]{user}).param("password", new String[]{password}).header("X-Forwarded-For", new Object[]{xForwardedFor})).andReturn().getResponse();
    }

    public String getAuthToken(String user, String password) throws Exception {
        return StringUtils.substringAfter((String)this.getAuthResponse(user, password).getHeader(AUTHORIZATION_HEADER), (String)AUTHORIZATION_TYPE);
    }

    public String getAuthTokenWithXForwardedForHeader(String user, String password, String xForwardedFor) throws Exception {
        return StringUtils.substringAfter((String)this.getAuthResponseWithXForwardedForHeader(user, password, xForwardedFor).getHeader(AUTHORIZATION_HEADER), (String)AUTHORIZATION_TYPE);
    }

    public String getPatchContent(List<Operation> ops) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(ops);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RequestPostProcessor ip(String ipAddress) {
        return request -> {
            request.setRemoteAddr(ipAddress);
            return request;
        };
    }
}

