/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.app.rest.utils.DiscoverQueryBuilder;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.FacetYearRange;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceImpl;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.configuration.HierarchicalSidebarFacetConfiguration;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.services.ConfigurationService;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@RunWith(value=MockitoJUnitRunner.class)
public class DiscoverQueryBuilderTest {
    @InjectMocks
    private DiscoverQueryBuilder queryBuilder;
    @Mock
    private ConfigurationService configurationService;
    @Mock
    private SolrServiceImpl searchService;
    @Mock
    private Context context;
    @Mock
    private IndexableObject scope;
    @Mock
    private IndexFactory indexFactory;
    private DiscoveryConfiguration discoveryConfiguration;
    private String query;
    private SearchFilter searchFilter;
    private PageRequest page;

    @Before
    public void setUp() throws Exception {
        this.queryBuilder.setIndexableFactories(Collections.singletonList(this.indexFactory));
        Mockito.when((Object)this.indexFactory.getType()).thenReturn((Object)IndexableItem.TYPE);
        Mockito.when((Object)this.configurationService.getIntProperty((String)ArgumentMatchers.eq((Object)"rest.search.max.results"), ArgumentMatchers.anyInt())).thenReturn((Object)100);
        Mockito.when((Object)this.searchService.toSortFieldIndex((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).then(invocation -> invocation.getArguments()[0] + "_sort");
        Mockito.when((Object)this.searchService.getFacetYearRange((Context)ArgumentMatchers.eq((Object)this.context), (IndexableObject)ArgumentMatchers.nullable(IndexableObject.class), (DiscoverySearchFilterFacet)ArgumentMatchers.any(DiscoverySearchFilterFacet.class), (List)ArgumentMatchers.any(), (DiscoverQuery)ArgumentMatchers.any(DiscoverQuery.class))).then(invocation -> new FacetYearRange((DiscoverySearchFilterFacet)invocation.getArguments()[2]));
        Mockito.when((Object)this.searchService.toFilterQuery((Context)ArgumentMatchers.any(Context.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).then(invocation -> new DiscoverFilterQuery((String)invocation.getArguments()[1], invocation.getArguments()[1] + ":\"" + invocation.getArguments()[3] + "\"", (String)invocation.getArguments()[3]));
        this.discoveryConfiguration = new DiscoveryConfiguration();
        this.discoveryConfiguration.setDefaultFilterQueries(Arrays.asList("archived:true"));
        DiscoveryHitHighlightingConfiguration discoveryHitHighlightingConfiguration = new DiscoveryHitHighlightingConfiguration();
        LinkedList<DiscoveryHitHighlightFieldConfiguration> discoveryHitHighlightFieldConfigurations = new LinkedList<DiscoveryHitHighlightFieldConfiguration>();
        DiscoveryHitHighlightFieldConfiguration discoveryHitHighlightFieldConfiguration = new DiscoveryHitHighlightFieldConfiguration();
        discoveryHitHighlightFieldConfiguration.setField("dc.title");
        DiscoveryHitHighlightFieldConfiguration discoveryHitHighlightFieldConfiguration1 = new DiscoveryHitHighlightFieldConfiguration();
        discoveryHitHighlightFieldConfiguration1.setField("fulltext");
        discoveryHitHighlightFieldConfigurations.add(discoveryHitHighlightFieldConfiguration1);
        discoveryHitHighlightFieldConfigurations.add(discoveryHitHighlightFieldConfiguration);
        discoveryHitHighlightingConfiguration.setMetadataFields(discoveryHitHighlightFieldConfigurations);
        this.discoveryConfiguration.setHitHighlightingConfiguration(discoveryHitHighlightingConfiguration);
        DiscoverySortConfiguration sortConfiguration = new DiscoverySortConfiguration();
        DiscoverySortFieldConfiguration defaultSort = new DiscoverySortFieldConfiguration();
        defaultSort.setMetadataField("dc.date.accessioned");
        defaultSort.setType("date");
        sortConfiguration.setDefaultSort(defaultSort);
        sortConfiguration.setDefaultSortOrder(DiscoverySortConfiguration.SORT_ORDER.desc);
        DiscoverySortFieldConfiguration titleSort = new DiscoverySortFieldConfiguration();
        titleSort.setMetadataField("dc.title");
        sortConfiguration.setSortFields(Arrays.asList(titleSort));
        this.discoveryConfiguration.setSearchSortConfiguration(sortConfiguration);
        DiscoverySearchFilterFacet subjectFacet = new DiscoverySearchFilterFacet();
        subjectFacet.setIndexFieldName("subject");
        subjectFacet.setFacetLimit(5);
        DiscoverySearchFilterFacet dateFacet = new DiscoverySearchFilterFacet();
        dateFacet.setIndexFieldName("dateIssued");
        dateFacet.setType("date");
        dateFacet.setFacetLimit(6);
        HierarchicalSidebarFacetConfiguration hierarchyFacet = new HierarchicalSidebarFacetConfiguration();
        hierarchyFacet.setIndexFieldName("hierarchy");
        hierarchyFacet.setType("hierarchical");
        hierarchyFacet.setFacetLimit(7);
        hierarchyFacet.setSortOrderSidebar(DiscoveryConfigurationParameters.SORT.VALUE);
        this.discoveryConfiguration.setSidebarFacets(Arrays.asList(subjectFacet, dateFacet, hierarchyFacet));
        this.discoveryConfiguration.setSearchFilters(Arrays.asList(subjectFacet, dateFacet, hierarchyFacet));
        this.query = "my test case";
        this.searchFilter = new SearchFilter("subject", "equals", "Java");
        this.page = PageRequest.of((int)1, (int)10, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"dc.title"});
        this.queryBuilder.afterPropertiesSet();
    }

    @Test
    public void testBuildQuery() throws Exception {
        DiscoverQuery discoverQuery = this.queryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "item", (Pageable)this.page);
        Assert.assertThat((Object)discoverQuery.getFilterQueries(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"archived:true", "subject:\"Java\""}));
        Assert.assertThat((Object)discoverQuery.getQuery(), (Matcher)Matchers.is((Object)this.query));
        Assert.assertThat((Object)discoverQuery.getDSpaceObjectFilters(), (Matcher)Matchers.contains((Object[])new String[]{IndexableItem.TYPE}));
        Assert.assertThat((Object)discoverQuery.getSortField(), (Matcher)Matchers.is((Object)"dc.title_sort"));
        Assert.assertThat((Object)discoverQuery.getSortOrder(), (Matcher)Matchers.is((Object)DiscoverQuery.SORT_ORDER.asc));
        Assert.assertThat((Object)discoverQuery.getMaxResults(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)discoverQuery.getStart(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)discoverQuery.getFacetMinCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)discoverQuery.getFacetOffset(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.discoverFacetFieldMatcher(new DiscoverFacetField("subject", "text", 6, DiscoveryConfigurationParameters.SORT.COUNT)), this.discoverFacetFieldMatcher(new DiscoverFacetField("hierarchy", "hierarchical", 8, DiscoveryConfigurationParameters.SORT.VALUE))}));
        Assert.assertThat((Object)discoverQuery.getHitHighlightingFields(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)discoverQuery.getHitHighlightingFields(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.discoverHitHighlightingFieldMatcher(new DiscoverHitHighlightingField("dc.title", 0, 3)), this.discoverHitHighlightingFieldMatcher(new DiscoverHitHighlightingField("fulltext", 0, 3))}));
    }

    @Test
    public void testBuildQueryDefaults() throws Exception {
        DiscoverQuery discoverQuery = this.queryBuilder.buildQuery(this.context, null, this.discoveryConfiguration, null, null, Collections.emptyList(), null);
        Assert.assertThat((Object)discoverQuery.getFilterQueries(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"archived:true"}));
        Assert.assertThat((Object)discoverQuery.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString()));
        Assert.assertThat((Object)discoverQuery.getDSpaceObjectFilters(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)discoverQuery.getSortField(), (Matcher)Matchers.is((Object)"dc.date.accessioned_sort"));
        Assert.assertThat((Object)discoverQuery.getSortOrder(), (Matcher)Matchers.is((Object)DiscoverQuery.SORT_ORDER.desc));
        Assert.assertThat((Object)discoverQuery.getMaxResults(), (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)discoverQuery.getStart(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)discoverQuery.getFacetMinCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)discoverQuery.getFacetOffset(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.discoverFacetFieldMatcher(new DiscoverFacetField("subject", "text", 6, DiscoveryConfigurationParameters.SORT.COUNT)), this.discoverFacetFieldMatcher(new DiscoverFacetField("hierarchy", "hierarchical", 8, DiscoveryConfigurationParameters.SORT.VALUE))}));
        Assert.assertThat((Object)discoverQuery.getHitHighlightingFields(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)discoverQuery.getHitHighlightingFields(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.discoverHitHighlightingFieldMatcher(new DiscoverHitHighlightingField("dc.title", 0, 3)), this.discoverHitHighlightingFieldMatcher(new DiscoverHitHighlightingField("fulltext", 0, 3))}));
    }

    @Test
    public void testSortByScore() throws Exception {
        this.page = PageRequest.of((int)2, (int)10, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"SCORE"});
        DiscoverQuery discoverQuery = this.queryBuilder.buildQuery(this.context, null, this.discoveryConfiguration, null, null, Collections.emptyList(), (Pageable)this.page);
        Assert.assertThat((Object)discoverQuery.getFilterQueries(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"archived:true"}));
        Assert.assertThat((Object)discoverQuery.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString()));
        Assert.assertThat((Object)discoverQuery.getDSpaceObjectFilters(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)discoverQuery.getSortField(), (Matcher)Matchers.is((Object)"score_sort"));
        Assert.assertThat((Object)discoverQuery.getSortOrder(), (Matcher)Matchers.is((Object)DiscoverQuery.SORT_ORDER.asc));
        Assert.assertThat((Object)discoverQuery.getMaxResults(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)discoverQuery.getStart(), (Matcher)Matchers.is((Object)20));
        Assert.assertThat((Object)discoverQuery.getFacetMinCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)discoverQuery.getFacetOffset(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.discoverFacetFieldMatcher(new DiscoverFacetField("subject", "text", 6, DiscoveryConfigurationParameters.SORT.COUNT)), this.discoverFacetFieldMatcher(new DiscoverFacetField("hierarchy", "hierarchical", 8, DiscoveryConfigurationParameters.SORT.VALUE))}));
        Assert.assertThat((Object)discoverQuery.getHitHighlightingFields(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)discoverQuery.getHitHighlightingFields(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.discoverHitHighlightingFieldMatcher(new DiscoverHitHighlightingField("dc.title", 0, 3)), this.discoverHitHighlightingFieldMatcher(new DiscoverHitHighlightingField("fulltext", 0, 3))}));
    }

    @Test(expected=DSpaceBadRequestException.class)
    public void testInvalidDSOType() throws Exception {
        this.queryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "TEST", (Pageable)this.page);
    }

    @Test(expected=DSpaceBadRequestException.class)
    public void testInvalidSortField() throws Exception {
        this.page = PageRequest.of((int)2, (int)10, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"test"});
        this.queryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "ITEM", (Pageable)this.page);
    }

    @Test(expected=DSpaceBadRequestException.class)
    public void testInvalidSearchFilter1() throws Exception {
        this.searchFilter = new SearchFilter("test", "equals", "Smith, Donald");
        this.queryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "ITEM", (Pageable)this.page);
    }

    @Test(expected=DSpaceBadRequestException.class)
    public void testInvalidSearchFilter2() throws Exception {
        Mockito.when((Object)this.searchService.toFilterQuery((Context)ArgumentMatchers.any(Context.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenThrow(SQLException.class);
        this.queryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "ITEM", (Pageable)this.page);
    }

    @Test
    public void testBuildFacetQuery() throws Exception {
        DiscoverQuery discoverQuery = this.queryBuilder.buildFacetQuery(this.context, this.scope, this.discoveryConfiguration, "prefix", this.query, Arrays.asList(this.searchFilter), "item", (Pageable)this.page, "subject");
        Assert.assertThat((Object)discoverQuery.getFilterQueries(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"archived:true", "subject:\"Java\""}));
        Assert.assertThat((Object)discoverQuery.getQuery(), (Matcher)Matchers.is((Object)this.query));
        Assert.assertThat((Object)discoverQuery.getDSpaceObjectFilters(), (Matcher)Matchers.contains((Object[])new String[]{IndexableItem.TYPE}));
        Assert.assertThat((Object)discoverQuery.getSortField(), (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString()));
        Assert.assertThat((Object)discoverQuery.getMaxResults(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)discoverQuery.getStart(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)discoverQuery.getFacetMinCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)discoverQuery.getFacetOffset(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)discoverQuery.getFacetFields(), (Matcher)Matchers.contains(this.discoverFacetFieldMatcher(new DiscoverFacetField("subject", "text", 11, DiscoveryConfigurationParameters.SORT.COUNT, "prefix"))));
    }

    @Test(expected=DSpaceBadRequestException.class)
    public void testInvalidSearchFacet() throws Exception {
        this.queryBuilder.buildFacetQuery(this.context, this.scope, this.discoveryConfiguration, null, this.query, Arrays.asList(this.searchFilter), "item", (Pageable)this.page, "test");
    }

    public Matcher<DiscoverFacetField> discoverFacetFieldMatcher(DiscoverFacetField expected) {
        return Matchers.allOf(this.hasProperty(expected, DiscoverFacetField::getField, "field"), this.hasProperty(expected, DiscoverFacetField::getType, "type"), this.hasProperty(expected, DiscoverFacetField::getPrefix, "prefix"), this.hasProperty(expected, DiscoverFacetField::getLimit, "limit"), this.hasProperty(expected, DiscoverFacetField::getOffset, "offset"));
    }

    public Matcher<DiscoverHitHighlightingField> discoverHitHighlightingFieldMatcher(DiscoverHitHighlightingField expected) {
        return Matchers.allOf(this.hasProperty(expected, DiscoverHitHighlightingField::getField, "field"), this.hasProperty(expected, DiscoverHitHighlightingField::getMaxChars, "maxChars"), this.hasProperty(expected, DiscoverHitHighlightingField::getMaxSnippets, "maxSnippets"));
    }

    public <T, U> FeatureMatcher<T, U> hasProperty(T expected, final Function<T, U> property, String description) {
        return new FeatureMatcher<T, U>(Matchers.equalTo(property.apply(expected)), description, description){

            protected U featureValueOf(T actual) {
                return property.apply(actual);
            }
        };
    }
}

