/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sword2;

import org.dspace.app.rest.test.AbstractWebClientIntegrationTest;
import org.dspace.services.ConfigurationService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"swordv2-server.enabled = true"})
public class Swordv2IT
extends AbstractWebClientIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    private final String SERVICE_DOC_PATH = "/swordv2/servicedocument";
    private final String COLLECTION_PATH = "/swordv2/collection";
    private final String MEDIA_RESOURCE_PATH = "/swordv2/edit-media";
    private final String CONTAINER_PATH = "/swordv2/edit";
    private final String STATEMENT_PATH = "/swordv2/statement";

    @Before
    public void onlyRunIfConfigExists() {
        try {
            Class.forName("org.dspace.app.configuration.SWORDv2WebConfig");
        }
        catch (ClassNotFoundException ce) {
            Assume.assumeNoException((Throwable)ce);
        }
        this.configurationService.setProperty("swordv2-server.servicedocument.url", (Object)this.getURL("/swordv2/servicedocument"));
    }

    @Test
    public void serviceDocumentUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/swordv2/servicedocument");
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    public void serviceDocumentTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/swordv2/servicedocument", this.admin.getEmail(), this.password);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.OK));
        Assert.assertThat((Object)response.getHeaders().getContentType().toString(), (Matcher)CoreMatchers.equalTo((Object)"application/atomserv+xml;charset=UTF-8"));
        Assert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)"<version xmlns=\"http://purl.org/net/sword/terms/\">2.0</version>"));
    }

    @Test
    public void collectionUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.postResponseAsString("/swordv2/collection", null, null, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    @Ignore
    public void collectionTest() throws Exception {
    }

    @Test
    public void mediaResourceUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.postResponseAsString("/swordv2/edit-media", null, null, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    @Ignore
    public void mediaResourceTest() throws Exception {
    }

    @Test
    public void containerUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.postResponseAsString("/swordv2/edit", null, null, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    @Ignore
    public void containerTest() throws Exception {
    }

    @Test
    public void statementUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/swordv2/statement");
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.UNAUTHORIZED));
    }

    @Test
    @Ignore
    public void statementTest() throws Exception {
    }
}

