/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canRequestACopy", description="It can be used to verify if the user can request a copy of a bitstream")
public class RequestCopyFeature
implements AuthorizationFeature {
    Logger log = LogManager.getLogger();
    public static final String NAME = "canRequestACopy";
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private ConfigurationService configurationService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        BitstreamRest bitstreamRest;
        Bitstream bitstream;
        DSpaceObject parentObject;
        String requestType = this.configurationService.getProperty("request.item.type");
        if (StringUtils.isBlank((CharSequence)requestType)) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)requestType, (CharSequence)"logged")) {
            EPerson currentUser = context.getCurrentUser();
            if (currentUser == null) {
                return false;
            }
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)requestType, (CharSequence)"all")) {
            this.log.warn("The configuration parameter \"request.item.type\" contains an invalid value.");
            return false;
        }
        if (object instanceof ItemRest) {
            ItemRest itemRest = (ItemRest)object;
            String id = itemRest.getId();
            Item item = (Item)this.itemService.find(context, UUID.fromString(id));
            if (!item.isArchived()) {
                return false;
            }
            List bunds = this.itemService.getBundles(item, "ORIGINAL");
            for (Bundle bund : bunds) {
                List bitstreams = bund.getBitstreams();
                for (Bitstream bitstream2 : bitstreams) {
                    boolean authorized = this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)bitstream2, 0);
                    if (authorized) continue;
                    return true;
                }
            }
        } else if (object instanceof BitstreamRest && (parentObject = this.bitstreamService.getParentObject(context, (DSpaceObject)(bitstream = this.bitstreamService.find(context, UUID.fromString((bitstreamRest = (BitstreamRest)object).getId()))))) instanceof Item && ((Item)parentObject).isArchived()) {
            return !this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)bitstream, 0);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.item", "core.bitstream"};
    }
}

