/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.MetadataValueList;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ItemConverter
extends DSpaceObjectConverter<Item, ItemRest>
implements IndexableObjectConverter<Item, ItemRest> {
    @Autowired
    private ItemService itemService;
    private static final Logger log = LogManager.getLogger(ItemConverter.class);

    public ItemRest convert(Item obj, Projection projection) {
        ItemRest item = (ItemRest)super.convert((DSpaceObject)obj, projection);
        item.setInArchive(obj.isArchived());
        item.setDiscoverable(obj.isDiscoverable());
        item.setWithdrawn(obj.isWithdrawn());
        item.setLastModified(obj.getLastModified());
        List entityTypes = this.itemService.getMetadata(obj, "dspace", "entity", "type", "*", false);
        if (CollectionUtils.isNotEmpty((Collection)entityTypes) && StringUtils.isNotBlank((CharSequence)((MetadataValue)entityTypes.get(0)).getValue())) {
            item.setEntityType(((MetadataValue)entityTypes.get(0)).getValue());
        }
        return item;
    }

    public MetadataValueList getPermissionFilteredMetadata(Context context, Item obj) {
        List fullList = this.itemService.getMetadata(obj, "*", "*", "*", "*", true);
        LinkedList<MetadataValue> returnList = new LinkedList<MetadataValue>();
        try {
            if (context != null && this.authorizeService.isAdmin(context)) {
                return new MetadataValueList(fullList);
            }
            for (MetadataValue mv : fullList) {
                MetadataField metadataField = mv.getMetadataField();
                if (this.metadataExposureService.isHidden(context, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier())) continue;
                returnList.add(mv);
            }
        }
        catch (SQLException e) {
            log.error("Error filtering item metadata based on permissions", (Throwable)e);
        }
        return new MetadataValueList(returnList);
    }

    protected ItemRest newInstance() {
        return new ItemRest();
    }

    public Class<Item> getModelClass() {
        return Item.class;
    }

    public boolean supportsModel(IndexableObject idxo) {
        return idxo.getIndexedObject() instanceof Item;
    }
}

