/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.link.search.SearchResultsResourceHalLinkFactory;
import org.dspace.app.rest.model.DiscoveryResultsRest;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.app.rest.model.SearchResultEntryRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.hateoas.SearchFacetEntryResource;
import org.dspace.app.rest.model.hateoas.SearchResultEntryResource;
import org.dspace.app.rest.model.hateoas.annotations.RelNameDSpaceResource;
import org.dspace.app.rest.utils.Utils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@RelNameDSpaceResource(value="discover")
public class SearchResultsResource
extends HALResource<SearchResultsRest> {
    @JsonIgnore
    private List<SearchResultEntryResource> entryResources;

    public SearchResultsResource(SearchResultsRest data, Utils utils, Pageable pageable) {
        super((Object)data);
        this.addEmbeds(data, utils, pageable);
    }

    private void addEmbeds(SearchResultsRest data, Utils utils, Pageable pageable) {
        this.embedSearchResults(data, utils, pageable);
        this.embedFacetResults(data);
    }

    private void embedFacetResults(SearchResultsRest data) {
        LinkedList<SearchFacetEntryResource> facetResources = new LinkedList<SearchFacetEntryResource>();
        for (SearchFacetEntryRest searchFacetEntryRest : CollectionUtils.emptyIfNull((Collection)data.getFacets())) {
            facetResources.add(new SearchFacetEntryResource(searchFacetEntryRest, (DiscoveryResultsRest)data));
        }
        this.embedResource("facets", facetResources);
    }

    private void embedSearchResults(SearchResultsRest data, Utils utils, Pageable pageable) {
        this.entryResources = new LinkedList();
        for (SearchResultEntryRest searchResultEntry : CollectionUtils.emptyIfNull((Collection)data.getSearchResults())) {
            this.entryResources.add(new SearchResultEntryResource(searchResultEntry, utils));
        }
        PageImpl page = new PageImpl(this.entryResources, pageable, data.getTotalNumberOfResults());
        SearchResultsResourceHalLinkFactory linkFactory = new SearchResultsResourceHalLinkFactory();
        EmbeddedPage embeddedPage = new EmbeddedPage(linkFactory.buildSearchBaseLink((DiscoveryResultsRest)data).toUriString(), (Page)page, this.entryResources, "objects");
        this.embedResource("searchResult", (Object)embeddedPage);
    }
}

