/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.projection;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.AbstractProjection;
import org.springframework.data.domain.PageRequest;
import org.springframework.hateoas.Link;

public class EmbedRelsProjection
extends AbstractProjection {
    public static final String NAME = "embedrels";
    private final Set<String> embedRels;
    private Map<String, Integer> embedSizes;

    public EmbedRelsProjection(Set<String> embedRels, Set<String> embedSizes) {
        this.embedRels = embedRels;
        this.embedSizes = embedSizes.stream().filter(embedSize -> StringUtils.contains((CharSequence)embedSize, (CharSequence)"=")).map(embedSize -> embedSize.split("=")).collect(Collectors.toMap(split -> split[0], split -> NumberUtils.toInt((String)split[1], (int)0)));
    }

    public String getName() {
        return NAME;
    }

    public boolean allowEmbedding(HALResource<? extends RestAddressableModel> halResource, LinkRest linkRest, Link ... oldLinks) {
        if (((RestAddressableModel)halResource.getContent()).getEmbedLevel() == 0 && this.embedRels.contains(linkRest.name())) {
            return true;
        }
        StringBuilder fullName = new StringBuilder();
        for (Link oldLink : oldLinks) {
            fullName.append(oldLink.getRel().value()).append("/");
        }
        fullName.append(linkRest.name());
        if (this.embedRels.contains(fullName.toString())) {
            return true;
        }
        fullName.append("/");
        for (String embedRel : this.embedRels) {
            if (!embedRel.startsWith(fullName.toString())) continue;
            return true;
        }
        return false;
    }

    public PageRequest getPagingOptions(String rel, HALResource<? extends RestAddressableModel> resource, Link ... oldLinks) {
        Integer size = this.getPaginationSize(rel, resource, oldLinks);
        if (size != null && size > 0) {
            return PageRequest.of((int)0, (int)size);
        }
        return null;
    }

    private Integer getPaginationSize(String rel, HALResource<? extends RestAddressableModel> resource, Link ... oldLinks) {
        if (((RestAddressableModel)resource.getContent()).getEmbedLevel() == 0 && this.embedSizes.containsKey(rel)) {
            return (Integer)this.embedSizes.get(rel);
        }
        StringBuilder fullName = new StringBuilder();
        for (Link oldLink : oldLinks) {
            fullName.append(oldLink.getRel().value()).append("/");
        }
        fullName.append(rel);
        if (this.embedSizes.containsKey(fullName.toString())) {
            return (Integer)this.embedSizes.get(fullName.toString());
        }
        return null;
    }

    public Map<String, Integer> getEmbedSizes() {
        return this.embedSizes;
    }

    public void setEmbedSizes(Map<String, Integer> embedSizes) {
        this.embedSizes = embedSizes;
    }
}

