/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageVersions", description="It can be used to verify if the user can create/delete or update the version of an Item")
public class CanManageVersionsFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageVersions";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ItemService itemService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof ItemRest) {
            EPerson currentUser = context.getCurrentUser();
            if (Objects.isNull(currentUser)) {
                return false;
            }
            if (this.authorizeService.isAdmin(context)) {
                return true;
            }
            if (this.configurationService.getBooleanProperty("versioning.submitterCanCreateNewVersion")) {
                Item item = (Item)this.itemService.find(context, UUID.fromString(((ItemRest)object).getUuid()));
                EPerson submitter = item.getSubmitter();
                return Objects.nonNull(submitter) && currentUser.getID().equals(submitter.getID());
            }
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

