/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.model.ClaimedTaskRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.WorkflowActionRest;
import org.dspace.app.rest.model.WorkflowItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.discovery.IndexableObject;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClaimedTaskConverter
implements IndexableObjectConverter<ClaimedTask, ClaimedTaskRest> {
    @Autowired
    private ConverterService converter;
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;

    @Override
    public ClaimedTaskRest convert(ClaimedTask obj, Projection projection) {
        ClaimedTaskRest taskRest = new ClaimedTaskRest();
        taskRest.setProjection(projection);
        XmlWorkflowItem witem = obj.getWorkflowItem();
        taskRest.setId(obj.getID());
        taskRest.setWorkflowitem((WorkflowItemRest)this.converter.toRest(witem, projection));
        taskRest.setAction((WorkflowActionRest)this.converter.toRest(this.xmlWorkflowFactory.getActionByName(obj.getActionID()), projection));
        taskRest.setOwner((EPersonRest)this.converter.toRest(obj.getOwner(), projection));
        return taskRest;
    }

    @Override
    public Class<ClaimedTask> getModelClass() {
        return ClaimedTask.class;
    }

    @Override
    public boolean supportsModel(IndexableObject idxo) {
        return idxo.getIndexedObject() instanceof ClaimedTask;
    }
}

