/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.TemplateItemRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.model.wrapper.TemplateItem;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.utils.CollectionRestEqualityUtils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowService;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowUtils;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="core.collection")
public class CollectionRestRepository
extends DSpaceObjectRestRepository<Collection, CollectionRest> {
    public static Logger log = LogManager.getLogger(CollectionRestRepository.class);
    @Autowired
    CommunityService communityService;
    @Autowired
    CollectionRestEqualityUtils collectionRestEqualityUtils;
    @Autowired
    private CollectionService cs;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private PoolTaskService poolTaskService;
    @Autowired
    private CollectionRoleService collectionRoleService;
    @Autowired
    SearchService searchService;

    public CollectionRestRepository(CollectionService dsoService) {
        super(dsoService);
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'READ')")
    public CollectionRest findOne(Context context, UUID id) {
        Collection collection = null;
        try {
            collection = (Collection)this.cs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (collection == null) {
            return null;
        }
        return (CollectionRest)this.converter.toRest(collection, this.utils.obtainProjection());
    }

    @Override
    public Page<CollectionRest> findAll(Context context, Pageable pageable) {
        try {
            if (this.authorizeService.isAdmin(context)) {
                long total = this.cs.countTotal(context);
                List collections = this.cs.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
                return this.converter.toRestPage(collections, pageable, total, this.utils.obtainProjection());
            }
            LinkedList<Collection> collections = new LinkedList<Collection>();
            DiscoverQuery discoverQuery = new DiscoverQuery();
            discoverQuery.setDSpaceObjectFilter(IndexableCollection.TYPE);
            discoverQuery.setStart(Math.toIntExact(pageable.getOffset()));
            discoverQuery.setMaxResults(pageable.getPageSize());
            DiscoverResult resp = this.searchService.search(context, discoverQuery);
            long tot = resp.getTotalSearchResults();
            for (IndexableObject solrCollections : resp.getIndexableObjects()) {
                Collection c = (Collection)((IndexableCollection)solrCollections).getIndexedObject();
                collections.add(c);
            }
            return this.converter.toRestPage(collections, pageable, tot, this.utils.obtainProjection());
        }
        catch (SQLException | SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="findSubmitAuthorizedByCommunity")
    public Page<CollectionRest> findSubmitAuthorizedByCommunity(@Parameter(value="uuid", required=true) UUID communityUuid, Pageable pageable, @Parameter(value="query") String q) {
        try {
            Context context = this.obtainContext();
            Community com = (Community)this.communityService.find(context, communityUuid);
            if (com == null) {
                throw new ResourceNotFoundException("core.community with id: " + communityUuid + " not found");
            }
            List collections = this.cs.findCollectionsWithSubmit(q, context, com, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
            int tot = this.cs.countCollectionsWithSubmit(q, context, com);
            return this.converter.toRestPage(collections, pageable, tot, this.utils.obtainProjection());
        }
        catch (SQLException | SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="findSubmitAuthorized")
    public Page<CollectionRest> findSubmitAuthorized(@Parameter(value="query") String q, Pageable pageable) throws SearchServiceException {
        try {
            Context context = this.obtainContext();
            List collections = this.cs.findCollectionsWithSubmit(q, context, null, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
            int tot = this.cs.countCollectionsWithSubmit(q, context, null);
            return this.converter.toRestPage(collections, pageable, tot, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="findAdminAuthorized")
    public Page<CollectionRest> findAdminAuthorized(Pageable pageable, @Parameter(value="query") String query) {
        try {
            Context context = this.obtainContext();
            List collections = this.authorizeService.findAdminAuthorizedCollection(context, query, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
            long tot = this.authorizeService.countAdminAuthorizedCollection(context, query);
            return this.converter.toRestPage(collections, pageable, tot, this.utils.obtainProjection());
        }
        catch (SQLException | SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    @Override
    public Class<CollectionRest> getDomainClass() {
        return CollectionRest.class;
    }

    @Override
    protected CollectionRest createAndReturn(Context context) throws AuthorizeException {
        throw new DSpaceBadRequestException("Cannot create a Collection without providing a parent Community.");
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'ADD')")
    protected CollectionRest createAndReturn(Context context, UUID id) throws AuthorizeException {
        Collection collection;
        CollectionRest collectionRest;
        if (id == null) {
            throw new DSpaceBadRequestException("Parent Community UUID is null. Cannot create a Collection without providing a parent Community");
        }
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = req.getInputStream();
            collectionRest = (CollectionRest)mapper.readValue((InputStream)input, CollectionRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body.", e1);
        }
        try {
            Community parent = (Community)this.communityService.find(context, id);
            if (parent == null) {
                throw new UnprocessableEntityException("Parent community for id: " + id + " not found");
            }
            collection = this.cs.create(context, parent);
            this.cs.update(context, (DSpaceObject)collection);
            this.metadataConverter.mergeMetadata(context, collection, collectionRest.getMetadata());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to create new Collection under parent Community " + id, e);
        }
        return (CollectionRest)this.converter.toRest(collection, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'WRITE')")
    protected CollectionRest put(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        CollectionRest collectionRest;
        try {
            collectionRest = (CollectionRest)new ObjectMapper().readValue(jsonNode.toString(), CollectionRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing collection json: " + e.getMessage());
        }
        Collection collection = (Collection)this.cs.find(context, id);
        if (collection == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        CollectionRest originalCollectionRest = (CollectionRest)this.converter.toRest(collection, this.utils.obtainProjection());
        if (!this.collectionRestEqualityUtils.isCollectionRestEqualWithoutMetadata(originalCollectionRest, collectionRest)) {
            throw new IllegalArgumentException("The UUID in the Json and the UUID in the url do not match: " + id + ", " + collectionRest.getId());
        }
        this.metadataConverter.setMetadata(context, collection, collectionRest.getMetadata());
        return (CollectionRest)this.converter.toRest(collection, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'DELETE')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        try {
            Collection collection = (Collection)this.cs.find(context, id);
            if (collection == null) {
                throw new ResourceNotFoundException("core.collection with id: " + id + " not found");
            }
            this.cs.delete(context, (DSpaceObject)collection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete Collection with id = " + id, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete collection because the logo couldn't be deleted", e);
        }
    }

    public BitstreamRest setLogo(Context context, Collection collection, MultipartFile uploadfile) throws IOException, AuthorizeException, SQLException {
        if (collection.getLogo() != null) {
            throw new UnprocessableEntityException("The collection with the given uuid already has a logo: " + collection.getID());
        }
        Bitstream bitstream = this.cs.setLogo(context, collection, uploadfile.getInputStream());
        this.cs.update(context, (DSpaceObject)collection);
        this.bitstreamService.update(context, (DSpaceObject)bitstream);
        return (BitstreamRest)this.converter.toRest((Bitstream)context.reloadEntity((ReloadableEntity)bitstream), this.utils.obtainProjection());
    }

    public TemplateItemRest createTemplateItem(Context context, Collection collection, TemplateItemRest inputItemRest) throws SQLException, AuthorizeException {
        if (collection.getTemplateItem() != null) {
            throw new UnprocessableEntityException("Collection with ID " + collection.getID() + " already contains a template item");
        }
        this.cs.createTemplateItem(context, collection);
        Item item = collection.getTemplateItem();
        this.metadataConverter.setMetadata(context, item, inputItemRest.getMetadata());
        item.setDiscoverable(false);
        this.cs.update(context, (DSpaceObject)collection);
        this.itemService.update(context, (DSpaceObject)item);
        return (TemplateItemRest)this.converter.toRest(new TemplateItem(item), this.utils.obtainProjection());
    }

    public TemplateItemRest getTemplateItem(Collection collection) throws SQLException {
        Item item = collection.getTemplateItem();
        if (item == null) {
            throw new ResourceNotFoundException("TemplateItem from core.collection with id: " + collection.getID() + " not found");
        }
        try {
            return (TemplateItemRest)this.converter.toRest(new TemplateItem(item), this.utils.obtainProjection());
        }
        catch (IllegalArgumentException e) {
            throw new UnprocessableEntityException("The item with id " + item.getID() + " is not a template item");
        }
    }

    public GroupRest createAdminGroup(Context context, HttpServletRequest request, Collection collection) throws SQLException, AuthorizeException {
        Group group = this.cs.createAdministrators(context, collection);
        return this.populateGroupInformation(context, request, group);
    }

    public void deleteAdminGroup(Context context, Collection collection) throws SQLException, AuthorizeException, IOException {
        Group adminGroup = collection.getAdministrators();
        this.cs.removeAdministrators(context, collection);
        this.groupService.delete(context, (DSpaceObject)adminGroup);
    }

    public GroupRest createSubmitterGroup(Context context, HttpServletRequest request, Collection collection) throws SQLException, AuthorizeException {
        Group group = this.cs.createSubmitters(context, collection);
        return this.populateGroupInformation(context, request, group);
    }

    public void deleteSubmitterGroup(Context context, Collection collection) throws SQLException, AuthorizeException, IOException {
        Group submitters = collection.getSubmitters();
        this.cs.removeSubmitters(context, collection);
        this.groupService.delete(context, (DSpaceObject)submitters);
    }

    public GroupRest createItemReadGroup(Context context, HttpServletRequest request, Collection collection) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageDefaultReadGroup((Context)context, (Collection)collection);
        context.turnOffAuthorisationSystem();
        Group role = this.cs.createDefaultReadGroup(context, collection, "ITEM", 10);
        context.restoreAuthSystemState();
        return this.populateGroupInformation(context, request, role);
    }

    public void deleteItemReadGroup(Context context, Collection collection) throws SQLException, AuthorizeException, IOException {
        List itemGroups = this.authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 10);
        Group itemReadGroup = (Group)itemGroups.get(0);
        this.groupService.delete(context, (DSpaceObject)itemReadGroup);
        this.authorizeService.addPolicy(context, (DSpaceObject)collection, 10, this.groupService.findByName(context, "Anonymous"));
    }

    public GroupRest createBitstreamReadGroup(Context context, HttpServletRequest request, Collection collection) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageDefaultReadGroup((Context)context, (Collection)collection);
        context.turnOffAuthorisationSystem();
        Group role = this.cs.createDefaultReadGroup(context, collection, "BITSTREAM", 9);
        context.restoreAuthSystemState();
        return this.populateGroupInformation(context, request, role);
    }

    public void deleteBitstreamReadGroup(Context context, Collection collection) throws SQLException, AuthorizeException, IOException {
        List itemGroups = this.authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 9);
        Group itemReadGroup = (Group)itemGroups.get(0);
        this.groupService.delete(context, (DSpaceObject)itemReadGroup);
        this.authorizeService.addPolicy(context, (DSpaceObject)collection, 9, this.groupService.findByName(context, "Anonymous"));
    }

    private GroupRest populateGroupInformation(Context context, HttpServletRequest request, Group group) throws SQLException, AuthorizeException {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        try {
            List dcTitleMetadata;
            ServletInputStream input = request.getInputStream();
            groupRest = (GroupRest)mapper.readValue((InputStream)input, GroupRest.class);
            if (groupRest.isPermanent() || StringUtils.isNotBlank((CharSequence)groupRest.getName())) {
                throw new UnprocessableEntityException("The given GroupRest object has to be non-permanent and can't contain a name");
            }
            MetadataRest metadata = groupRest.getMetadata();
            SortedMap<String, List<MetadataValueRest>> map = metadata.getMap();
            if (map != null && (dcTitleMetadata = (List)map.get("dc.title")) != null && !dcTitleMetadata.isEmpty()) {
                throw new UnprocessableEntityException("The given GroupRest can't contain a dc.title mdv");
            }
            this.metadataConverter.setMetadata(context, group, metadata);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body.", e1);
        }
        return (GroupRest)this.converter.toRest(group, this.utils.obtainProjection());
    }

    public GroupRest getWorkflowGroupForRole(Context context, Collection collection, String workflowRole) throws SQLException, IOException, WorkflowConfigurationException, AuthorizeException, WorkflowException {
        if (WorkflowUtils.getCollectionAndRepositoryRoles((Collection)collection).get(workflowRole) == null) {
            throw new ResourceNotFoundException("Couldn't find role for: " + workflowRole + " in the collection with UUID: " + collection.getID());
        }
        Group group = this.workflowService.getWorkflowRoleGroup(context, collection, workflowRole, null);
        if (group == null) {
            return null;
        }
        return (GroupRest)this.converter.toRest(group, this.utils.obtainProjection());
    }

    public GroupRest createWorkflowGroupForRole(Context context, HttpServletRequest request, Collection collection, String workflowRole) throws SQLException, WorkflowConfigurationException, AuthorizeException, WorkflowException, IOException {
        AuthorizeUtil.authorizeManageWorkflowsGroup((Context)context, (Collection)collection);
        context.turnOffAuthorisationSystem();
        Group group = this.workflowService.createWorkflowRoleGroup(context, collection, workflowRole);
        context.restoreAuthSystemState();
        this.populateGroupInformation(context, request, group);
        return (GroupRest)this.converter.toRest(group, this.utils.obtainProjection());
    }

    public void deleteWorkflowGroupForRole(Context context, HttpServletRequest request, Collection collection, String workflowRole) throws SQLException, WorkflowConfigurationException, AuthorizeException, WorkflowException, IOException {
        Group group = this.workflowService.getWorkflowRoleGroup(context, collection, workflowRole, null);
        if (!this.poolTaskService.findByGroup(context, group).isEmpty()) {
            throw new UnprocessableEntityException("The Group that was attempted to be deleted still has Pooltasks open");
        }
        if (group == null) {
            throw new ResourceNotFoundException("The requested Group was not found");
        }
        List collectionRoles = this.collectionRoleService.findByGroup(context, group);
        if (!collectionRoles.isEmpty()) {
            collectionRoles.stream().forEach(collectionRole -> {
                try {
                    this.collectionRoleService.delete(context, collectionRole);
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        this.groupService.delete(context, (DSpaceObject)group);
    }
}

