/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ParameterValueRest;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.model.ScriptRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.scripts.handler.impl.RestDSpaceRunnableHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="system.script")
public class ScriptRestRepository
extends DSpaceRestRepository<ScriptRest, String> {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ScriptRest findOne(Context context, String name) {
        ScriptConfiguration scriptConfiguration = this.scriptService.getScriptConfiguration(name);
        if (scriptConfiguration != null) {
            if (scriptConfiguration.isAllowedToExecute(context)) {
                return (ScriptRest)this.converter.toRest(scriptConfiguration, this.utils.obtainProjection());
            }
            throw new AccessDeniedException("The current user was not authorized to access this script");
        }
        throw new DSpaceBadRequestException("The script with name: " + name + " could not be found");
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ScriptRest> findAll(Context context, Pageable pageable) {
        List scriptConfigurations = this.scriptService.getScriptConfigurations(context);
        return this.converter.toRestPage(scriptConfigurations, pageable, this.utils.obtainProjection());
    }

    @Override
    public Class<ScriptRest> getDomainClass() {
        return ScriptRest.class;
    }

    public ProcessRest startProcess(Context context, String scriptName, List<MultipartFile> files) throws SQLException, IOException, AuthorizeException, IllegalAccessException, InstantiationException {
        String properties = this.requestService.getCurrentRequest().getServletRequest().getParameter("properties");
        List<DSpaceCommandLineParameter> dSpaceCommandLineParameters = this.processPropertiesToDSpaceCommandLineParameters(properties);
        ScriptConfiguration scriptToExecute = this.scriptService.getScriptConfiguration(scriptName);
        if (scriptToExecute == null) {
            throw new DSpaceBadRequestException("The script for name: " + scriptName + " wasn't found");
        }
        if (!scriptToExecute.isAllowedToExecute(context)) {
            throw new AuthorizeException("Current user is not eligible to execute script with name: " + scriptName);
        }
        RestDSpaceRunnableHandler restDSpaceRunnableHandler = new RestDSpaceRunnableHandler(context.getCurrentUser(), scriptToExecute.getName(), dSpaceCommandLineParameters);
        List<String> args = this.constructArgs(dSpaceCommandLineParameters);
        this.runDSpaceScript(files, context, scriptToExecute, restDSpaceRunnableHandler, args);
        return (ProcessRest)this.converter.toRest(restDSpaceRunnableHandler.getProcess(context), this.utils.obtainProjection());
    }

    private List<DSpaceCommandLineParameter> processPropertiesToDSpaceCommandLineParameters(String propertiesJson) throws IOException {
        List<Object> parameterValueRestList = new LinkedList();
        ObjectMapper objectMapper = new ObjectMapper();
        if (StringUtils.isNotBlank((CharSequence)propertiesJson)) {
            parameterValueRestList = Arrays.asList((ParameterValueRest[])objectMapper.readValue(propertiesJson, ParameterValueRest[].class));
        }
        LinkedList<DSpaceCommandLineParameter> dSpaceCommandLineParameters = new LinkedList<DSpaceCommandLineParameter>();
        dSpaceCommandLineParameters.addAll(parameterValueRestList.stream().map(x -> this.dSpaceRunnableParameterConverter.toModel((ParameterValueRest)x)).collect(Collectors.toList()));
        return dSpaceCommandLineParameters;
    }

    private List<String> constructArgs(List<DSpaceCommandLineParameter> dSpaceCommandLineParameters) {
        ArrayList<String> args = new ArrayList<String>();
        for (DSpaceCommandLineParameter parameter : dSpaceCommandLineParameters) {
            args.add(parameter.getName());
            if (parameter.getValue() == null) continue;
            args.add(parameter.getValue());
        }
        return args;
    }

    private void runDSpaceScript(List<MultipartFile> files, Context context, ScriptConfiguration scriptToExecute, RestDSpaceRunnableHandler restDSpaceRunnableHandler, List<String> args) throws IOException, SQLException, AuthorizeException, InstantiationException, IllegalAccessException {
        DSpaceRunnable dSpaceRunnable = this.scriptService.createDSpaceRunnableForScriptConfiguration(scriptToExecute);
        try {
            dSpaceRunnable.initialize(args.toArray(new String[0]), (DSpaceRunnableHandler)restDSpaceRunnableHandler, context.getCurrentUser());
            this.checkFileNames(dSpaceRunnable, files);
            this.processFiles(context, restDSpaceRunnableHandler, files);
            restDSpaceRunnableHandler.schedule(dSpaceRunnable);
        }
        catch (ParseException e) {
            dSpaceRunnable.printHelp();
            restDSpaceRunnableHandler.handleException("Failed to parse the arguments given to the script with name: " + scriptToExecute.getName() + " and args: " + args, (Exception)((Object)e));
        }
    }

    private void processFiles(Context context, RestDSpaceRunnableHandler restDSpaceRunnableHandler, List<MultipartFile> files) throws IOException, SQLException, AuthorizeException {
        for (MultipartFile file : files) {
            restDSpaceRunnableHandler.writeFilestream(context, file.getOriginalFilename(), file.getInputStream(), "inputfile");
        }
    }

    private void checkFileNames(DSpaceRunnable dSpaceRunnable, List<MultipartFile> files) {
        LinkedList<String> fileNames = new LinkedList<String>();
        for (MultipartFile file : files) {
            String fileName = file.getOriginalFilename();
            if (fileNames.contains(fileName)) {
                throw new UnprocessableEntityException("There are two files with the same name: " + fileName);
            }
            fileNames.add(fileName);
        }
        List fileNamesFromOptions = dSpaceRunnable.getFileNamesFromInputStreamOptions();
        if (!fileNames.containsAll(fileNamesFromOptions)) {
            throw new UnprocessableEntityException("Files given in properties aren't all present in the request");
        }
    }
}

