/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.handler;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.repository.handler.UriListHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.service.ExternalDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class ExternalSourceEntryItemUriListHandler<T>
implements UriListHandler<T> {
    private List<RequestMethod> allowedRequestMethods = new LinkedList<RequestMethod>(Arrays.asList(RequestMethod.POST));
    @Autowired
    private ExternalDataService externalDataService;
    @Autowired
    private CollectionService collectionService;
    private static final Logger log = LogManager.getLogger(ExternalSourceEntryItemUriListHandler.class);

    @Override
    public boolean supports(List<String> uriList, String method, Class clazz) {
        if (!this.allowedRequestMethods.contains(RequestMethod.valueOf((String)method))) {
            return false;
        }
        for (String string : uriList) {
            if (StringUtils.contains((CharSequence)string, (CharSequence)"integration/externalsources") && StringUtils.contains((CharSequence)string, (CharSequence)"entryValues")) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(Context context, HttpServletRequest request, List<String> uriList) throws AuthorizeException {
        if (uriList.size() > 1) {
            return false;
        }
        String owningCollectionString = request.getParameter("owningCollection");
        if (StringUtils.isBlank((CharSequence)owningCollectionString)) {
            return false;
        }
        try {
            Collection collection = (Collection)this.collectionService.find(context, UUID.fromString(owningCollectionString));
            if (collection == null) {
                return false;
            }
        }
        catch (SQLException e) {
            log.error("Search for owningCollection with UUID:" + owningCollectionString + " resulted in an error", (Throwable)e);
            return false;
        }
        return true;
    }

    public WorkspaceItem createWorkspaceItem(Context context, HttpServletRequest request, List<String> uriList) throws SQLException, AuthorizeException {
        ExternalDataObject dataObject = this.getExternalDataObjectFromUriList(uriList);
        String owningCollectionUuid = request.getParameter("owningCollection");
        try {
            Collection collection = (Collection)this.collectionService.find(context, UUID.fromString(owningCollectionUuid));
            return this.externalDataService.createWorkspaceItemFromExternalDataObject(context, dataObject, collection);
        }
        catch (SQLException | AuthorizeException e) {
            log.error("An error occured when trying to create item in collection with uuid: " + owningCollectionUuid, e);
            throw e;
        }
    }

    private ExternalDataObject getExternalDataObjectFromUriList(List<String> uriList) {
        String inputString = uriList.get(0);
        Pattern pattern = Pattern.compile("api\\/integration\\/externalsources\\/(.*)\\/entryValues\\/(.*)");
        Matcher matcher = pattern.matcher(inputString);
        matcher.find();
        String externalSourceIdentifer = matcher.group(1);
        String id = matcher.group(2);
        Optional externalDataObject = this.externalDataService.getExternalDataObject(externalSourceIdentifer, id);
        return (ExternalDataObject)externalDataObject.orElseThrow(() -> new ResourceNotFoundException("Couldn't find an ExternalSource for source: " + externalSourceIdentifer + " and ID: " + id));
    }
}

