/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.apache.commons.lang3.BooleanUtils;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.core.Context;

public abstract class PatchOperation<M> {
    public static final String OPERATION_REPLACE = "replace";
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_COPY = "copy";
    public static final String OPERATION_MOVE = "move";
    public static final String OPERATION_REMOVE = "remove";

    public abstract M perform(Context var1, M var2, Operation var3) throws SQLException;

    public void checkOperationValue(Object value) {
        if (value == null) {
            throw new DSpaceBadRequestException("No value provided for the operation.");
        }
        if (value instanceof String && ((String)value).trim().isBlank()) {
            throw new DSpaceBadRequestException("Value can't be empty or just spaces.");
        }
    }

    Boolean getBooleanOperationValue(Object value) {
        Boolean bool;
        if (value instanceof String) {
            bool = BooleanUtils.toBooleanObject((String)((String)value));
            if (bool == null) {
                throw new DSpaceBadRequestException("Boolean value not provided.");
            }
        } else {
            bool = (Boolean)value;
        }
        return bool;
    }

    public abstract boolean supports(Object var1, Operation var2);
}

