/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ProcessRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(ProcessRestPermissionEvaluatorPlugin.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission restPermission) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"process")) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getServletRequest());
        try {
            int processId = Integer.parseInt(targetId.toString());
            Process process = this.processService.find(context, processId);
            if (process == null) {
                return true;
            }
            if (context.getCurrentUser() != null && (context.getCurrentUser().equals((Object)process.getEPerson()) || this.authorizeService.isAdmin(context))) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

