/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.query.SearchQueryConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.InvalidSearchRequestException;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.FacetYearRange;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class DiscoverQueryBuilder
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(DiscoverQueryBuilder.class);
    @Autowired
    private SearchService searchService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private List<IndexFactory> indexableFactories;
    private int pageSizeLimit;

    public void afterPropertiesSet() throws Exception {
        this.pageSizeLimit = this.configurationService.getIntProperty("rest.search.max.results", 100);
    }

    public DiscoverQuery buildQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String query, List<SearchFilter> searchFilters, String dsoType, Pageable page) throws DSpaceBadRequestException {
        List<String> dsoTypes = dsoType != null ? Collections.singletonList(dsoType) : Collections.emptyList();
        return this.buildQuery(context, scope, discoveryConfiguration, query, searchFilters, dsoTypes, page);
    }

    public DiscoverQuery buildQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String query, List<SearchFilter> searchFilters, List<String> dsoTypes, Pageable page) throws DSpaceBadRequestException {
        DiscoverQuery queryArgs = this.buildCommonDiscoverQuery(context, discoveryConfiguration, query, searchFilters, dsoTypes);
        this.addFaceting(context, scope, queryArgs, discoveryConfiguration);
        this.configurePagination(page, queryArgs);
        this.configureSorting(page, queryArgs, discoveryConfiguration.getSearchSortConfiguration());
        this.addDiscoveryHitHighlightFields(discoveryConfiguration, queryArgs);
        return queryArgs;
    }

    private void addDiscoveryHitHighlightFields(DiscoveryConfiguration discoveryConfiguration, DiscoverQuery queryArgs) {
        if (discoveryConfiguration.getHitHighlightingConfiguration() != null) {
            List metadataFields = discoveryConfiguration.getHitHighlightingConfiguration().getMetadataFields();
            for (DiscoveryHitHighlightFieldConfiguration fieldConfiguration : metadataFields) {
                queryArgs.addHitHighlightingField(new DiscoverHitHighlightingField(fieldConfiguration.getField(), fieldConfiguration.getMaxSize(), fieldConfiguration.getSnippets()));
            }
        }
    }

    public DiscoverQuery buildFacetQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String prefix, String query, List<SearchFilter> searchFilters, String dsoType, Pageable page, String facetName) throws DSpaceBadRequestException {
        List<String> dsoTypes = dsoType != null ? Collections.singletonList(dsoType) : Collections.emptyList();
        return this.buildFacetQuery(context, scope, discoveryConfiguration, prefix, query, searchFilters, dsoTypes, page, facetName);
    }

    public DiscoverQuery buildFacetQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String prefix, String query, List<SearchFilter> searchFilters, List<String> dsoTypes, Pageable page, String facetName) throws DSpaceBadRequestException {
        DiscoverQuery queryArgs = this.buildCommonDiscoverQuery(context, discoveryConfiguration, query, searchFilters, dsoTypes);
        this.addFacetingForFacets(context, scope, prefix, queryArgs, discoveryConfiguration, facetName, page);
        queryArgs.setMaxResults(0);
        this.configurePaginationForFacets(page, queryArgs);
        return queryArgs;
    }

    private void configurePaginationForFacets(Pageable page, DiscoverQuery queryArgs) {
        if (page != null) {
            queryArgs.setFacetOffset(Math.toIntExact(page.getOffset()));
        }
    }

    private DiscoverQuery addFacetingForFacets(Context context, IndexableObject scope, String prefix, DiscoverQuery queryArgs, DiscoveryConfiguration discoveryConfiguration, String facetName, Pageable page) throws DSpaceBadRequestException {
        DiscoverySearchFilterFacet facet = discoveryConfiguration.getSidebarFacet(facetName);
        if (facet == null) {
            throw new DSpaceBadRequestException(facetName + " is not a valid search facet");
        }
        queryArgs.setFacetMinCount(1);
        int pageSize = Math.min(this.pageSizeLimit, page.getPageSize());
        this.fillFacetIntoQueryArgs(context, scope, prefix, queryArgs, facet, pageSize);
        return queryArgs;
    }

    private void fillFacetIntoQueryArgs(Context context, IndexableObject scope, String prefix, DiscoverQuery queryArgs, DiscoverySearchFilterFacet facet, int pageSize) {
        if (facet.getType().equals("date")) {
            try {
                FacetYearRange facetYearRange = this.searchService.getFacetYearRange(context, scope, facet, queryArgs.getFilterQueries(), queryArgs);
                queryArgs.addYearRangeFacet(facet, facetYearRange);
            }
            catch (Exception e) {
                log.error(org.dspace.core.LogManager.getHeader((Context)context, (String)"Error in Discovery while setting up date facet range", (String)("date facet: " + facet)), (Throwable)e);
            }
        } else {
            int facetLimit = pageSize + 1;
            queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), facet.getType(), facetLimit, facet.getSortOrderSidebar(), StringUtils.trimToNull((String)prefix)));
        }
    }

    private DiscoverQuery buildCommonDiscoverQuery(Context context, DiscoveryConfiguration discoveryConfiguration, String query, List<SearchFilter> searchFilters, List<String> dsoTypes) throws DSpaceBadRequestException {
        DiscoverQuery queryArgs = this.buildBaseQueryForConfiguration(discoveryConfiguration);
        queryArgs.addFilterQueries(this.convertFilters(context, discoveryConfiguration, searchFilters));
        if (StringUtils.isNotBlank((CharSequence)query)) {
            queryArgs.setQuery(query);
        }
        if (CollectionUtils.isNotEmpty(dsoTypes)) {
            dsoTypes.stream().map(this::getDsoType).forEach(arg_0 -> ((DiscoverQuery)queryArgs).addDSpaceObjectFilter(arg_0));
        }
        return queryArgs;
    }

    private DiscoverQuery buildBaseQueryForConfiguration(DiscoveryConfiguration discoveryConfiguration) {
        DiscoverQuery queryArgs = new DiscoverQuery();
        queryArgs.setDiscoveryConfigurationName(discoveryConfiguration.getId());
        queryArgs.addFilterQueries(discoveryConfiguration.getDefaultFilterQueries().toArray(new String[discoveryConfiguration.getDefaultFilterQueries().size()]));
        return queryArgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureSorting(Pageable page, DiscoverQuery queryArgs, DiscoverySortConfiguration searchSortConfiguration) throws DSpaceBadRequestException {
        DiscoverySortFieldConfiguration sortFieldConfiguration;
        Sort sort;
        String sortBy = null;
        String sortOrder = null;
        if (page != null && (sort = page.getSort()) != null && sort.iterator().hasNext()) {
            Sort.Order order = (Sort.Order)sort.iterator().next();
            sortBy = order.getProperty();
            sortOrder = order.getDirection().name();
        }
        if (StringUtils.isNotBlank(sortBy) && !this.isConfigured(sortBy, searchSortConfiguration)) {
            throw new InvalidSearchRequestException("The field: " + sortBy + "is not configured for the configuration!");
        }
        if (sortBy == null) {
            sortBy = this.getDefaultSortField(searchSortConfiguration);
        }
        if (sortOrder == null) {
            sortOrder = this.getDefaultSortDirection(searchSortConfiguration, sortOrder);
        }
        if ((sortFieldConfiguration = searchSortConfiguration.getSortFieldConfiguration(sortBy)) == null) throw new DSpaceBadRequestException(sortBy + " is not a valid sort field");
        String sortField = this.searchService.toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
        if ("asc".equalsIgnoreCase(sortOrder)) {
            queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.asc);
            return;
        } else {
            if (!"desc".equalsIgnoreCase(sortOrder)) throw new DSpaceBadRequestException(sortOrder + " is not a valid sort order");
            queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.desc);
        }
    }

    private boolean isConfigured(String sortBy, DiscoverySortConfiguration searchSortConfiguration) {
        return Objects.nonNull(searchSortConfiguration.getSortFieldConfiguration(sortBy));
    }

    private String getDefaultSortDirection(DiscoverySortConfiguration searchSortConfiguration, String sortOrder) {
        if (Objects.nonNull(searchSortConfiguration.getSortFields()) && !searchSortConfiguration.getSortFields().isEmpty()) {
            sortOrder = ((DiscoverySortFieldConfiguration)searchSortConfiguration.getSortFields().get(0)).getDefaultSortOrder().name();
        }
        return sortOrder;
    }

    private String getDefaultSortField(DiscoverySortConfiguration searchSortConfiguration) {
        String sortBy = "score";
        if (Objects.nonNull(searchSortConfiguration.getSortFields()) && !searchSortConfiguration.getSortFields().isEmpty()) {
            DiscoverySortFieldConfiguration defaultSort = (DiscoverySortFieldConfiguration)searchSortConfiguration.getSortFields().get(0);
            if (StringUtils.isBlank((CharSequence)defaultSort.getMetadataField())) {
                return sortBy;
            }
            sortBy = defaultSort.getMetadataField();
        }
        return sortBy;
    }

    private void configurePagination(Pageable page, DiscoverQuery queryArgs) {
        if (page != null) {
            queryArgs.setMaxResults(Math.min(this.pageSizeLimit, page.getPageSize()));
            queryArgs.setStart(Math.toIntExact(page.getOffset()));
        } else {
            queryArgs.setMaxResults(this.pageSizeLimit);
            queryArgs.setStart(0);
        }
    }

    private String getDsoType(String dsoType) throws DSpaceBadRequestException {
        for (IndexFactory indexFactory : this.indexableFactories) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)indexFactory.getType(), (CharSequence)dsoType)) continue;
            return indexFactory.getType();
        }
        throw new DSpaceBadRequestException(dsoType + " is not a valid DSpace Object type");
    }

    public void setIndexableFactories(List<IndexFactory> indexableFactories) {
        this.indexableFactories = indexableFactories;
    }

    private String[] convertFilters(Context context, DiscoveryConfiguration discoveryConfiguration, List<SearchFilter> searchFilters) throws DSpaceBadRequestException {
        ArrayList<String> filterQueries = new ArrayList<String>(CollectionUtils.size(searchFilters));
        SearchQueryConverter searchQueryConverter = new SearchQueryConverter();
        List<SearchFilter> transformedFilters = searchQueryConverter.convert(searchFilters);
        try {
            for (SearchFilter searchFilter : CollectionUtils.emptyIfNull(transformedFilters)) {
                DiscoverySearchFilter filter = discoveryConfiguration.getSearchFilter(searchFilter.getName());
                if (filter == null) {
                    throw new DSpaceBadRequestException(searchFilter.getName() + " is not a valid search filter");
                }
                DiscoverFilterQuery filterQuery = this.searchService.toFilterQuery(context, filter.getIndexFieldName(), searchFilter.getOperator(), searchFilter.getValue(), discoveryConfiguration);
                if (filterQuery == null) continue;
                filterQueries.add(filterQuery.getFilterQuery());
            }
        }
        catch (SQLException e) {
            throw new DSpaceBadRequestException("There was a problem parsing the search filters.", e);
        }
        return filterQueries.toArray(new String[filterQueries.size()]);
    }

    private DiscoverQuery addFaceting(Context context, IndexableObject scope, DiscoverQuery queryArgs, DiscoveryConfiguration discoveryConfiguration) {
        List facets = discoveryConfiguration.getSidebarFacets();
        log.debug("facets for configuration " + discoveryConfiguration.getId() + ": " + (facets != null ? Integer.valueOf(facets.size()) : null));
        if (facets != null) {
            queryArgs.setFacetMinCount(1);
            for (DiscoverySearchFilterFacet facet : facets) {
                this.fillFacetIntoQueryArgs(context, scope, null, queryArgs, facet, facet.getFacetLimit());
            }
        }
        return queryArgs;
    }
}

