/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.BundleMatcher;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.repository.ItemRestRepository;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ItemRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private CollectionService collectionService;
    private Item publication1;
    private Item author1;
    private Item author2;
    RelationshipType isAuthorOfPublication;
    private Relationship relationship1;
    private Relationship relationship2;

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem3, "Public item 3", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllWithPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup("reviewer", new EPerson[]{this.admin}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withTemplateItem().build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("In Progress Item").withIssueDate("2018-02-05").withAuthor("Doe, Jane").withAuthor("Smith, Jennifer").build();
        Item itemInWorkspace = workspaceItem.getItem();
        XmlWorkflowItem workflowItem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Item in Workflow").withIssueDate("2019-06-03").withAuthor("Smith, Jennifer").withAuthor("Doe, John").build();
        Item itemInWorkflow = workflowItem.getItem();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem3, "Public item 3", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(itemInWorkspace, "In Progress Item", "2018-02-05"), ItemMatcher.matchItemWithTitleAndDateIssued(itemInWorkflow, "Item in Workflow", "2019-06-03"), ItemMatcher.matchItemProperties(col2.getTemplateItem())})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem3, "Public item 3", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(itemInWorkspace, "In Progress Item", "2018-02-05"), ItemMatcher.matchItemWithTitleAndDateIssued(itemInWorkflow, "Item in Workflow", "2019-06-03"), ItemMatcher.matchItemProperties(col2.getTemplateItem())})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/items?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        Matcher<? super Object> publicItem1Matcher = ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", publicItem1Matcher));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", publicItem1Matcher));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).param("embed", new String[]{"bundles,owningCollection"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchEmbeds("bundles[]", "owningCollection"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", publicItem1Matcher));
    }

    @Test
    public void findOneFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        Matcher<? super Object> publicItem1Matcher = ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.adminGroup", (Matcher)Matchers.nullValue()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.adminGroup", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findOneRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + publicItem1.getID() + "/bundles"))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
    }

    @Test
    public void findOneTestWrongUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void withdrawPatchTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void withdrawPatchUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String tokenAdmin = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void withdrawPatchForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdmin = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void valueMissingForWithdrawalOperation() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(this.admin);
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withdrawn().build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", null);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void reinstatePatchTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(this.admin);
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withdrawn().build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)false);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void reinstatePatchUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(this.admin);
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withdrawn().build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)false);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void reinstatePatchForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.setCurrentUser(this.admin);
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withdrawn().build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)false);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void makeDiscoverablePatchTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)true)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)true)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void makeDiscoverablePatchUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void makeDiscoverablePatchForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void makeUnDiscoverablePatchTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)false);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)false)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void useStringForBooleanTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)"false");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)false)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void makeUnDiscoverablePatchUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)false);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void makeUnDiscoverablePatchForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)false);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void valueMissingForDiscoverableOperation() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Not discoverable item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", null);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)true)));
        ArrayList ops2 = new ArrayList();
        ReplaceOperation replaceOperation2 = new ReplaceOperation("/discoverable", null);
        ops.add((Operation)replaceOperation);
        String patchBody2 = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item2.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item2.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void deleteOneArchivedTestAsSystemAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + publicItem.getID() + "/bundles"))));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void deleteOneArchivedTestAsCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson col1Admin = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("col1admin@email.com").withPassword(this.password).withNameInMetadata("Col1", "Admin").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{col1Admin}).build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + publicItem.getID() + "/bundles"))));
        String token = this.getAuthToken(col1Admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void deleteOneArchivedTestAsOtherCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson col1Admin = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("col1admin@email.com").withPassword(this.password).withNameInMetadata("Col1", "Admin").build();
        EPerson col2Admin = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("col2admin@email.com").withPassword(this.password).withNameInMetadata("Col2", "Admin").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{col1Admin}).build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withAdminGroup(new EPerson[]{col2Admin}).build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + publicItem.getID() + "/bundles"))));
        String token = this.getAuthToken(col2Admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteOneTemplateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withTemplateItem().build();
        Item templateItem = col1.getTemplateItem();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + templateItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(422));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + templateItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void deleteOneWorkspaceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + workspaceItem.getItem().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(422));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + workspaceItem.getItem().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void embargoAccessTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item embargoedItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("embargoed item 1").withIssueDate("2017-12-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withEmbargoPeriod("6 months").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token1 = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(embargoedItem1, "embargoed item 1", "2017-12-18")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
    }

    @Test
    public void embargoAccessGrantAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminParentCommunity = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCommunity@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{adminParentCommunity}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson adminChild2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminChild2@mail.com").withPassword("qwerty05").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").withAdminGroup(new EPerson[]{adminChild2}).build();
        EPerson adminCollection1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCollection1@mail.com").withPassword("qwerty02").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCollection1}).build();
        EPerson adminCollection2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCollection2@mail.com").withPassword("qwerty03").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withAdminGroup(new EPerson[]{adminCollection2}).build();
        Item embargoedItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2015-10-21").withAuthor("Smith, Donald").withSubject("ExtraEntry").withEmbargoPeriod("1 week").build();
        this.context.restoreAuthSystemState();
        String tokenAdminParentCommunity = this.getAuthToken(adminParentCommunity.getEmail(), "qwerty01");
        this.getClient(tokenAdminParentCommunity).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(embargoedItem))));
        String tokenAdminCollection1 = this.getAuthToken(adminCollection1.getEmail(), "qwerty02");
        this.getClient(tokenAdminCollection1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(embargoedItem))));
        String tokenAdminCollection2 = this.getAuthToken(adminCollection2.getEmail(), "qwerty03");
        this.getClient(tokenAdminCollection2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(embargoedItem))));
        String tokenAdminChild2 = this.getAuthToken(adminChild2.getEmail(), "qwerty05");
        this.getClient(tokenAdminChild2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void expiredEmbargoTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item embargoedItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("embargoed item 1").withIssueDate("2017-11-18").withAuthor("Smith, Donald").withEmbargoPeriod("-2 week").build();
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(embargoedItem))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + embargoedItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(embargoedItem))));
    }

    @Test
    public void undiscoverableAccessTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item unDiscoverableYetAccessibleItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Undiscoverable item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + unDiscoverableYetAccessibleItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(unDiscoverableYetAccessibleItem1, "Undiscoverable item 1", "2017-10-17"))));
        String token1 = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + unDiscoverableYetAccessibleItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(unDiscoverableYetAccessibleItem1, "Undiscoverable item 1", "2017-10-17"))));
    }

    @Test
    public void privateGroupAccessTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Group staffGroup = GroupBuilder.createGroup((Context)this.context).withName("Staff").build();
        Item restrictedItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Restricted item 1").withIssueDate("2017-12-18").withReaderGroup(staffGroup).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        EPerson staffEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("professor@myuni.edu").withPassword("s3cr3t").withNameInMetadata("Doctor", "Professor").withGroupMembership(staffGroup).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + restrictedItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token1 = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + restrictedItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(restrictedItem1, "Restricted item 1", "2017-12-18")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        String token2 = this.getAuthToken("professor@myuni.edu", "s3cr3t");
        this.getClient(token2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + restrictedItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(restrictedItem1, "Restricted item 1", "2017-12-18")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
    }

    @Test
    public void restrictedGroupAccessForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson memberRestrictGroup = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Group restrictGroup = GroupBuilder.createGroup((Context)this.context).addMember(memberRestrictGroup).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item itemRestrictedByGroup = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2011-11-13").withAuthor("Smith, Donald").withReaderGroup(restrictGroup).build();
        this.context.restoreAuthSystemState();
        String tokenMemberRestrictedGroup = this.getAuthToken(memberRestrictGroup.getEmail(), "qwerty01");
        this.getClient(tokenMemberRestrictedGroup).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemRestrictedByGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(itemRestrictedByGroup))));
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemRestrictedByGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemRestrictedByGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void restrictedGroupAccessGrantAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminParentCommunity = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCommunity@mail.com").withPassword("qwerty01").build();
        Group restrictedGroup = GroupBuilder.createGroup((Context)this.context).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{adminParentCommunity}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson adminChild2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminChild2@mail.com").withPassword("qwerty05").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        EPerson adminCollection1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCollection1@mail.com").withPassword("qwerty02").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCollection1}).build();
        EPerson adminCollection2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCollection2@mail.com").withPassword("qwerty03").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withAdminGroup(new EPerson[]{adminCollection2}).build();
        Item itemRestrictedByGroup = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2015-10-21").withAuthor("Smith, Donald").withSubject("ExtraEntry").withReaderGroup(restrictedGroup).build();
        this.context.restoreAuthSystemState();
        String tokenAdminParentCommunity = this.getAuthToken(adminParentCommunity.getEmail(), "qwerty01");
        this.getClient(tokenAdminParentCommunity).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemRestrictedByGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(itemRestrictedByGroup))));
        String tokenAdminCollection1 = this.getAuthToken(adminCollection1.getEmail(), "qwerty02");
        this.getClient(tokenAdminCollection1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemRestrictedByGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(itemRestrictedByGroup))));
        String tokenAdminCollection2 = this.getAuthToken(adminCollection2.getEmail(), "qwerty03");
        this.getClient(tokenAdminCollection2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemRestrictedByGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdminChild2 = this.getAuthToken(adminChild2.getEmail(), "qwerty05");
        this.getClient(tokenAdminCollection2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemRestrictedByGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        UUID idRef = null;
        AtomicReference idRefNoEmbeds = new AtomicReference();
        try {
            ObjectMapper mapper = new ObjectMapper();
            ItemRest itemRest = new ItemRest();
            ItemRest itemRestFull = new ItemRest();
            itemRest.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
            itemRest.setInArchive(true);
            itemRest.setDiscoverable(true);
            itemRest.setWithdrawn(false);
            itemRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
            itemRestFull.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
            itemRestFull.setInArchive(true);
            itemRestFull.setDiscoverable(true);
            itemRestFull.setWithdrawn(false);
            itemRestFull.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            String itemUuidString = String.valueOf(map.get("uuid"));
            String itemHandleString = String.valueOf(map.get("handle"));
            idRef = UUID.fromString(itemUuidString);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + idRef.toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)itemHandleString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample item created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text"))))));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).param("projection", new String[]{"full"}).content(mapper.writeValueAsBytes((Object)itemRestFull)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchFullEmbeds())).andDo(result -> idRefNoEmbeds.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        catch (Throwable throwable) {
            ItemBuilder.deleteItem(idRef);
            ItemBuilder.deleteItem((UUID)((UUID)idRefNoEmbeds.get()));
            throw throwable;
        }
        ItemBuilder.deleteItem((UUID)idRef);
        ItemBuilder.deleteItem((UUID)((UUID)idRefNoEmbeds.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String itemUuidString = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            ItemRest itemRest = new ItemRest();
            itemRest.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
            itemRest.setInArchive(true);
            itemRest.setDiscoverable(true);
            itemRest.setWithdrawn(false);
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            itemUuidString = String.valueOf(map.get("uuid"));
            String itemHandleString = String.valueOf(map.get("handle"));
            itemRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("New Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("New title")}));
            itemRest.setUuid(itemUuidString);
            itemRest.setHandle(itemHandleString);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"New title")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)itemHandleString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample item created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "New Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "New title"))))));
        }
        catch (Throwable throwable) {
            ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
            throw throwable;
        }
        ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String itemUuidString = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            ItemRest itemRest = new ItemRest();
            itemRest.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
            itemRest.setInArchive(true);
            itemRest.setDiscoverable(true);
            itemRest.setWithdrawn(false);
            itemRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            itemUuidString = String.valueOf(map.get("uuid"));
            String itemHandleString = String.valueOf(map.get("handle"));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)itemHandleString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample item created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text"))))));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        }
        catch (Throwable throwable) {
            ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
            throw throwable;
        }
        ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteItemUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String itemUuidString = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            ItemRest itemRest = new ItemRest();
            itemRest.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
            itemRest.setInArchive(true);
            itemRest.setDiscoverable(true);
            itemRest.setWithdrawn(false);
            itemRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            itemUuidString = String.valueOf(map.get("uuid"));
            String itemHandleString = String.valueOf(map.get("handle"));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)itemHandleString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample item created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text"))))));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        }
        catch (Throwable throwable) {
            ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
            throw throwable;
        }
        ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
    }

    @Test
    public void deleteOneWrongUuidResourceNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void patchItemMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchItemMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/core/items/" + item.getID(), expectedStatus);
    }

    @Test
    public void testCreateItemInArchiveFalseBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        ObjectMapper mapper = new ObjectMapper();
        ItemRest itemRest = new ItemRest();
        itemRest.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
        itemRest.setInArchive(false);
        itemRest.setDiscoverable(true);
        itemRest.setWithdrawn(false);
        itemRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testCreateItemInvalidCollectionBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        ObjectMapper mapper = new ObjectMapper();
        ItemRest itemRest = new ItemRest();
        itemRest.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
        itemRest.setInArchive(false);
        itemRest.setDiscoverable(true);
        itemRest.setWithdrawn(false);
        itemRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateTestEPersonWithoutPermissionForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String itemUuidString = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            ItemRest itemRest = new ItemRest();
            itemRest.setName("Practices of research data curation in institutional repositories: A qualitative view from repository staff");
            itemRest.setInArchive(true);
            itemRest.setDiscoverable(true);
            itemRest.setWithdrawn(false);
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            itemUuidString = String.valueOf(map.get("uuid"));
            String itemHandleString = String.valueOf(map.get("handle"));
            itemRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample item created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("New Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("New title")}));
            itemRest.setUuid(itemUuidString);
            itemRest.setHandle(itemHandleString);
            token = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)itemRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        catch (Throwable throwable) {
            ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
            throw throwable;
        }
        ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createItemFromExternalSources() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String itemUuidString = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            itemUuidString = String.valueOf(map.get("uuid"));
            String itemHandleString = String.valueOf(map.get("handle"));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)itemHandleString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.contributor.author", "Donald, Smith")})))));
        }
        catch (Throwable throwable) {
            ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
            throw throwable;
        }
        ItemBuilder.deleteItem((UUID)UUID.fromString(itemUuidString));
    }

    @Test
    public void createItemFromExternalSourcesNoOwningCollectionUuidBadRequest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/items", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createItemFromExternalSourcesRandomOwningCollectionUuidBadRequest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + UUID.randomUUID()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createItemFromExternalSourcesWrongUriList() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/mock/mock/mock/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createItemFromExternalSourcesWrongSourceBadRequest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mockWrongSource/entryValues/one")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createItemFromExternalSourcesWrongIdResourceNotFound() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/azeazezaezeaz")).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void createItemFromExternalSourcesForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createItemFromExternalSourcesUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items?owningCollection=" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/integration/externalsources/mock/entryValues/one")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void specificEmbedTestMultipleLevelOfLinks() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "?embed=owningCollection/mappedItems/bundles/bitstreams&embed=owningCollection/logo"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(publicItem1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.defaultAccessConditions", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.logo", (Matcher)Matchers.nullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.mappedItems._embedded.mappedItems", (Matcher)Matchers.empty()));
    }

    @Test
    public void specificEmbedTestMultipleLevelOfLinksWithData() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.collectionService.addItem(this.context, col1, publicItem2);
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        String bitstreamContent2 = "ThisIsSomeDummyText";
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent2, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem2, (InputStream)is).withName("Bitstream2").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "?embed=owningCollection/mappedItems/bundles/bitstreams&embed=owningCollection/logo"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(publicItem1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationships", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.defaultAccessConditions", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.logo", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.logo._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.mappedItems._embedded.mappedItems", (Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.mappedItems._embedded.mappedItems[0]._embedded.bundles._embedded.bundles[0]._embedded.bitstreams._embedded.bitstreams", (Matcher)Matchers.contains(BitstreamMatcher.matchBitstreamEntryWithoutEmbed(bitstream2.getID(), bitstream2.getSizeBytes())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.mappedItems._embedded.mappedItems[0]_embedded.relationships", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.mappedItems._embedded.mappedItems[0]._embedded.bundles._embedded.bundles[0]._embedded.primaryBitstream", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.owningCollection._embedded.mappedItems._embedded.mappedItems[0]._embedded.bundles._embedded.bundles[0]._embedded.bitstreams._embedded.bitstreams[0]._embedded.format", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testHiddenMetadataForAnonymousUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withProvenanceData("Provenance data").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Public item 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadataDoesNotExist("dc.description.provenance")));
    }

    @Test
    public void testHiddenMetadataForAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withProvenanceData("Provenance data").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Public item 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.description.provenance", "Provenance data")));
    }

    @Test
    public void testHiddenMetadataForUserWithWriteRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withProvenanceData("Provenance data").build();
        this.context.restoreAuthSystemState();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withAction(1).withDspaceObject((DSpaceObject)item).build();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Public item 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadataDoesNotExist("dc.description.provenance")));
    }

    @Test
    public void testEntityTypePerson() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Person").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").withEntityType("Person").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Person")));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Person")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Person")));
    }

    @Test
    public void testEntityTypePublication() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Publication1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").withEntityType("Publication").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Publication")));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Publication")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Publication")));
    }

    @Test
    public void testEntityTypeNull() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Unclassified item").withAuthor("Testy, TEst").withIssueDate("2015-01-01").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString())));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString())));
    }

    @Test
    public void testEntityTypeModification() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Publication1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString())));
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "Publication");
        values.add(value);
        AddOperation addOperation = new AddOperation("/metadata/dspace.entity.type", values);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Publication")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.entityType", (Matcher)Matchers.is((Object)"Publication")));
    }

    @Test
    public void findOneTestWithEmbedsWithNoPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item").build();
        Bundle bundle0 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 0").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 1").build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 2").build();
        Bundle bundle3 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 3").build();
        Bundle bundle4 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 4").build();
        Bundle bundle5 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 5").build();
        Bundle bundle6 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 6").build();
        Bundle bundle7 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 7").build();
        Bundle bundle8 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 8").build();
        Bundle bundle9 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 9").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("embed", new String[]{"bundles"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BundleMatcher.matchProperties(bundle0.getName(), bundle0.getID(), bundle0.getHandle(), bundle0.getType()), BundleMatcher.matchProperties(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType()), BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType()), BundleMatcher.matchProperties(bundle3.getName(), bundle3.getID(), bundle3.getHandle(), bundle3.getType()), BundleMatcher.matchProperties(bundle4.getName(), bundle4.getID(), bundle4.getHandle(), bundle4.getType()), BundleMatcher.matchProperties(bundle5.getName(), bundle5.getID(), bundle5.getHandle(), bundle5.getType()), BundleMatcher.matchProperties(bundle6.getName(), bundle6.getID(), bundle6.getHandle(), bundle6.getType()), BundleMatcher.matchProperties(bundle7.getName(), bundle7.getID(), bundle7.getHandle(), bundle7.getType()), BundleMatcher.matchProperties(bundle8.getName(), bundle8.getID(), bundle8.getHandle(), bundle8.getType()), BundleMatcher.matchProperties(bundle9.getName(), bundle9.getID(), bundle9.getHandle(), bundle9.getType())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithEmbedsWithPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item").build();
        Bundle bundle0 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 0").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 1").build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 2").build();
        Bundle bundle3 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 3").build();
        Bundle bundle4 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 4").build();
        Bundle bundle5 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 5").build();
        Bundle bundle6 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 6").build();
        Bundle bundle7 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 7").build();
        Bundle bundle8 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 8").build();
        Bundle bundle9 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 9").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("embed", new String[]{"bundles"}).param("embed.size", new String[]{"bundles=5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BundleMatcher.matchProperties(bundle0.getName(), bundle0.getID(), bundle0.getHandle(), bundle0.getType()), BundleMatcher.matchProperties(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType()), BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType()), BundleMatcher.matchProperties(bundle3.getName(), bundle3.getID(), bundle3.getHandle(), bundle3.getType()), BundleMatcher.matchProperties(bundle4.getName(), bundle4.getID(), bundle4.getHandle(), bundle4.getType())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithEmbedsWithInvalidPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item").build();
        Bundle bundle0 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 0").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 1").build();
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 2").build();
        Bundle bundle3 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 3").build();
        Bundle bundle4 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 4").build();
        Bundle bundle5 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 5").build();
        Bundle bundle6 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 6").build();
        Bundle bundle7 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 7").build();
        Bundle bundle8 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 8").build();
        Bundle bundle9 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 9").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("embed", new String[]{"bundles"}).param("embed.size", new String[]{"bundles=invalidPage"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BundleMatcher.matchProperties(bundle0.getName(), bundle0.getID(), bundle0.getHandle(), bundle0.getType()), BundleMatcher.matchProperties(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType()), BundleMatcher.matchProperties(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType()), BundleMatcher.matchProperties(bundle3.getName(), bundle3.getID(), bundle3.getHandle(), bundle3.getType()), BundleMatcher.matchProperties(bundle4.getName(), bundle4.getID(), bundle4.getHandle(), bundle4.getType()), BundleMatcher.matchProperties(bundle5.getName(), bundle5.getID(), bundle5.getHandle(), bundle5.getType()), BundleMatcher.matchProperties(bundle6.getName(), bundle6.getID(), bundle6.getHandle(), bundle6.getType()), BundleMatcher.matchProperties(bundle7.getName(), bundle7.getID(), bundle7.getHandle(), bundle7.getType()), BundleMatcher.matchProperties(bundle8.getName(), bundle8.getID(), bundle8.getHandle(), bundle8.getType()), BundleMatcher.matchProperties(bundle9.getName(), bundle9.getID(), bundle9.getHandle(), bundle9.getType())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithMultiLevelEmbedsWithNoPageSize() throws Exception {
        Bitstream bitstream9;
        Bitstream bitstream8;
        Bitstream bitstream7;
        Bitstream bitstream6;
        Bitstream bitstream5;
        Bitstream bitstream4;
        Bitstream bitstream3;
        Bitstream bitstream2;
        Bitstream bitstream1;
        Bitstream bitstream0;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item").build();
        Bundle bundle0 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 0").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream0 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream0").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream2").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream3 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream3").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream4 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream4").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream5 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream5").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream6 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream6").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream7 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream7").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream8 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream8").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream9 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream9").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("embed", new String[]{"bundles/bitstreams"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BundleMatcher.matchProperties(bundle0.getName(), bundle0.getID(), bundle0.getHandle(), bundle0.getType())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams._embedded.bitstreams", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BitstreamMatcher.matchProperties(bitstream0), BitstreamMatcher.matchProperties(bitstream1), BitstreamMatcher.matchProperties(bitstream2), BitstreamMatcher.matchProperties(bitstream3), BitstreamMatcher.matchProperties(bitstream4), BitstreamMatcher.matchProperties(bitstream5), BitstreamMatcher.matchProperties(bitstream6), BitstreamMatcher.matchProperties(bitstream7), BitstreamMatcher.matchProperties(bitstream8), BitstreamMatcher.matchProperties(bitstream9)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithMultiLevelEmbedsWithPageSize() throws Exception {
        Bitstream bitstream4;
        Bitstream bitstream3;
        Bitstream bitstream2;
        Bitstream bitstream1;
        Bitstream bitstream0;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item").build();
        Bundle bundle0 = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("Bundle 0").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream0 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream0").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream2").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream3 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream3").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream4 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream4").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream5 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream5").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream6 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream6").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream7 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream7").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream8 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream8").withMimeType("text/plain").build();
        }
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            Bitstream bitstream9 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle0, (InputStream)is).withName("Bitstream9").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("embed", new String[]{"bundles/bitstreams"}).param("embed.size", new String[]{"bundles/bitstreams=5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemProperties(item))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BundleMatcher.matchProperties(bundle0.getName(), bundle0.getID(), bundle0.getHandle(), bundle0.getType())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams._embedded.bitstreams", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BitstreamMatcher.matchProperties(bitstream0), BitstreamMatcher.matchProperties(bitstream1), BitstreamMatcher.matchProperties(bitstream2), BitstreamMatcher.matchProperties(bitstream3), BitstreamMatcher.matchProperties(bitstream4)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles[0]._embedded.bitstreams.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void deleteItemWithMinRelationshipsTest() throws Exception {
        this.initPublicationAuthorsRelationships();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + this.relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/relationships/" + this.relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(400));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + this.relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + this.relationship2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + this.relationship1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + this.relationship2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void deleteItemWithMinRelationshipsTest_copyVirtualMetadata_null() throws Exception {
        this.initPublicationAuthorsRelationships();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor']", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void deleteItemWithMinRelationshipsTest_copyVirtualMetadata_relationshiptypeid_isAuthorOfPublication() throws Exception {
        this.initPublicationAuthorsRelationships();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0]).param("copyVirtualMetadata", new String[]{String.valueOf(this.isAuthorOfPublication.getID())})).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.publication1.getID()))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.publication1.getID()))));
    }

    @Test
    public void deleteItemWithMinRelationshipsTest_copyVirtualMetadata_relationshiptypeid_other() throws Exception {
        this.initPublicationAuthorsRelationships();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        EntityType journalIssueEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"JournalIssue").build();
        EntityType journalVolumeEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"JournalVolume").build();
        RelationshipType isJournalVolumeOfIssueRelationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)journalIssueEntityType, (EntityType)journalVolumeEntityType, (String)"isIssueOfJournalVolume", (String)"isJournalVolumeOfIssue", (Integer)2, null, (Integer)0, null).withCopyToLeft(false).withCopyToRight(true).build();
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0]).param("copyVirtualMetadata", new String[]{String.valueOf(isJournalVolumeOfIssueRelationshipType.getID())})).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor']", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void deleteItemWithMinRelationshipsTest_copyVirtualMetadata_all() throws Exception {
        this.initPublicationAuthorsRelationships();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0]).param("copyVirtualMetadata", ItemRestRepository.COPYVIRTUAL_ALL)).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.publication1.getID()))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.publication1.getID()))));
    }

    @Test
    public void deleteItemWithMinRelationshipsTest_copyVirtualMetadata_configured_withCopyToRightTrueConfigured() throws Exception {
        this.initPublicationAuthorsRelationships();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0]).param("copyVirtualMetadata", ItemRestRepository.COPYVIRTUAL_CONFIGURED)).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.publication1.getID()))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor'][0].value", (Matcher)Matchers.is((Object)String.valueOf(this.publication1.getID()))));
    }

    @Test
    public void deleteItemWithMinRelationshipsTest_copyVirtualMetadata_configured_withCopyToRightFalseConfigured() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.author1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").withEntityType("Person").build();
        this.author2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withEntityType("Person").build();
        this.publication1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Publication1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").withEntityType("Publication").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Person").build();
        this.isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)person, (String)"isAuthorOfPublication", (String)"isPublicationOfAuthor", (Integer)2, null, (Integer)0, null).withCopyToLeft(false).withCopyToRight(false).build();
        this.relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)this.isAuthorOfPublication).build();
        this.relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author2, (RelationshipType)this.isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + this.publication1.getID()), (Object[])new Object[0]).param("copyVirtualMetadata", ItemRestRepository.COPYVIRTUAL_CONFIGURED)).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor']", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.author2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(200)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata['relation.isPublicationOfAuthor']", (Object[])new Object[0]).doesNotExist());
    }

    private void initPublicationAuthorsRelationships() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.author1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withPersonIdentifierLastName("Smith").withPersonIdentifierFirstName("Donald").withEntityType("Person").build();
        this.author2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Author2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withEntityType("Person").build();
        this.publication1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Publication1").withAuthor("Testy, TEst").withIssueDate("2015-01-01").withEntityType("Publication").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Person").build();
        this.isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publication, (EntityType)person, (String)"isAuthorOfPublication", (String)"isPublicationOfAuthor", (Integer)2, null, (Integer)0, null).withCopyToLeft(false).withCopyToRight(true).build();
        this.relationship1 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author1, (RelationshipType)this.isAuthorOfPublication).build();
        this.relationship2 = RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.publication1, (Item)this.author2, (RelationshipType)this.isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findWithdrawnItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)true);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.bundles.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/bundles")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.mappedCollections.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/mappedCollections")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.owningCollection.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/owningCollection")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.relationships.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/relationships")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.version.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/version")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.templateItemOf.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/templateItemOf"))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID() + "/owningCollection"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntryFullProjection(col1.getName(), col1.getID(), col1.getHandle())));
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)item.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.handle", (Matcher)Matchers.is((Object)item.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.bundles.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/bundles")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.mappedCollections.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/mappedCollections")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.owningCollection.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/owningCollection")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.relationships.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/relationships")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.version.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/version")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.templateItemOf.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/templateItemOf"))));
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)item.getName()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.handle", (Matcher)Matchers.is((Object)item.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.bundles.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/bundles")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.mappedCollections.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/mappedCollections")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.owningCollection.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/owningCollection")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.relationships.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/relationships")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.version.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/version")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.templateItemOf.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + item.getID().toString() + "/templateItemOf"))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void thumbnailEndpointTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test item -- thumbnail").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Bundle originalBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("ORIGINAL").build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("THUMBNAIL").build();
        InputStream is = IOUtils.toInputStream((String)"dummy", (String)"utf-8");
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test1.pdf").withMimeType("application/pdf").build();
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test2.pdf").withMimeType("application/pdf").build();
        Bitstream thumbnail = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test1.pdf.jpg").withMimeType("image/jpeg").build();
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test2.pdf.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)thumbnail.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream")));
    }

    @Test
    public void thumbnailEndpointMultipleThumbnailsWithPrimaryBitstreamTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test item -- thumbnail").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Bundle originalBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("ORIGINAL").build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("THUMBNAIL").build();
        InputStream is = IOUtils.toInputStream((String)"dummy", (String)"utf-8");
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test1.pdf").withMimeType("application/pdf").build();
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test2.pdf").withMimeType("application/pdf").build();
        Bitstream primaryBitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test3.pdf").withMimeType("application/pdf").build();
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test1.pdf.jpg").withMimeType("image/jpeg").build();
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test2.pdf.jpg").withMimeType("image/jpeg").build();
        Bitstream primaryThumbnail = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("test3.pdf.jpg").withMimeType("image/jpeg").build();
        originalBundle.setPrimaryBitstreamID(primaryBitstream);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)primaryThumbnail.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bitstream")));
    }

    @Test
    public void thumbnailEndpointItemWithoutThumbnailsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test item -- thumbnail").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Bundle originalBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("ORIGINAL").build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)item).withName("THUMBNAIL").build();
        InputStream is = IOUtils.toInputStream((String)"dummy", (String)"utf-8");
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)originalBundle, (InputStream)is).withName("test.pdf").withMimeType("application/pdf").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.context.turnOffAuthorisationSystem();
        BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)is).withName("random.pdf.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID() + "/thumbnail"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }
}

