/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.RelationshipRestRepositoryIT;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.RelationshipType;
import org.dspace.core.Context;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RightTiltedRelationshipRestRepositoryIT
extends RelationshipRestRepositoryIT {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.isOrgUnitOfPersonRelationshipType.setTilted(RelationshipType.Tilted.RIGHT);
        this.relationshipTypeService.update(this.context, (Object)this.isOrgUnitOfPersonRelationshipType);
        this.context.restoreAuthSystemState();
    }

    @Override
    @Test
    public void testIsOrgUnitOfPersonRelationshipMetadataViaREST() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)this.author1, (Item)this.orgUnit1, (RelationshipType)this.isOrgUnitOfPersonRelationshipType).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.author1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)String.format("$.metadata['%s.isOrgUnitOfPerson']", MetadataSchemaEnum.RELATION.getName()), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{uuid}", (Object[])new Object[]{this.orgUnit1.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata(String.format("%s.isPersonOfOrgUnit", MetadataSchemaEnum.RELATION.getName()), this.author1.getID().toString())));
    }
}

