/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.VersionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class VersionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    Item item;
    Version version;
    @Autowired
    private ItemService itemService;
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private InstallItemService installItemService;
    @Autowired
    private WorkspaceItemService workspaceItemService;

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.version = this.versioningService.createNewVersion(this.context, this.item);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findOneTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version))));
    }

    @Test
    public void findOneSubmitterNameVisisbleTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyFalseAdminUserLinkVisibleTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)false);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)true);
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyTrueNormalUserLinkVisibleTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyTrueAnonUserLinkVisibleTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Matcher)Matchers.is((Object)this.version.getEPerson().getFullName())));
    }

    @Test
    public void findOneSubmitterNameConfigurationPropertyFalseNormalUserLinkInvisibleTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)false);
        String adminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.submitterName", (Object[])new Object[0]).doesNotExist());
        this.configurationService.setProperty("versioning.item.history.include.submitter", (Object)true);
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)true);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)false);
    }

    @Test
    public void versionForItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, this.version.getItem());
        this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.version.getItem().getID() + "/version"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(this.version))));
    }

    @Test
    public void versionItemTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + this.version.getID() + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ItemMatcher.matchItemProperties(this.version.getItem()))));
    }

    @Test
    public void versionItemTestWrongId() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + (this.version.getID() + 5) * 57 + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

