/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanManageVersionsFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private Utils utils;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private ConfigurationService configurationService;
    private Item itemA;
    private EPerson user;
    private ItemRest itemARest;
    private Community communityA;
    private Collection collectionA;
    final String feature = "canManageVersions";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.user = EPersonBuilder.createEPerson((Context)this.context).withEmail("userEmail@test.com").withPassword(this.password).build();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("collectionA").build();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("itemA").build();
        this.context.restoreAuthSystemState();
        this.itemARest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
    }

    @Test
    public void anonymousHasNotAccessTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void epersonHasNotAccessTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void adminItemSuccessTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void submitterItemSuccessTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("versioning.submitterCanCreateNewVersion", (Object)true);
        this.itemA.setSubmitter(this.user);
        this.context.restoreAuthSystemState();
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void submitterItemWithPropertySubmitterCanCreateNewVersionIsFalseTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("versioning.submitterCanCreateNewVersion", (Object)false);
        this.itemA.setSubmitter(this.user);
        this.context.restoreAuthSystemState();
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageVersions"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.itemARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }
}

