/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="versioning.version")
public class VersionRestRepository
extends DSpaceRestRepository<VersionRest, Integer> {
    private static final Logger log = LogManager.getLogger(VersionRestRepository.class);
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private ConverterService converterService;

    @PreAuthorize(value="hasPermission(#id, 'VERSION', 'READ')")
    public VersionRest findOne(Context context, Integer id) {
        try {
            Version version = this.versioningService.getVersion(context, id.intValue());
            if (version == null) {
                throw new ResourceNotFoundException("Couldn't find version for id: " + id);
            }
            return (VersionRest)this.converterService.toRest((Object)version, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            log.error("Something with wrong getting version with id:" + id, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Page<VersionRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public Class<VersionRest> getDomainClass() {
        return VersionRest.class;
    }
}

