/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jose.JOSEException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.wrapper.AuthenticationToken;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.security.WebSecurityConfiguration;
import org.dspace.app.rest.security.jwt.LoginJWTTokenHandler;
import org.dspace.app.rest.security.jwt.ShortLivedJWTTokenHandler;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseCookie;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.stereotype.Component;

@Component
public class JWTTokenRestAuthenticationServiceImpl
implements RestAuthenticationService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RestAuthenticationService.class);
    private static final String AUTHORIZATION_COOKIE = "Authorization-cookie";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_TYPE = "Bearer";
    private static final String AUTHORIZATION_TOKEN_PARAMETER = "authentication-token";
    @Autowired
    private LoginJWTTokenHandler loginJWTTokenHandler;
    @Autowired
    private ShortLivedJWTTokenHandler shortLivedJWTTokenHandler;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private WebSecurityConfiguration webSecurityConfiguration;

    public void afterPropertiesSet() throws Exception {
    }

    public void addAuthenticationDataForUser(HttpServletRequest request, HttpServletResponse response, DSpaceAuthentication authentication, boolean addCookie) throws IOException {
        try {
            Context context = ContextUtil.obtainContext((ServletRequest)request);
            context.setCurrentUser(this.ePersonService.findByEmail(context, authentication.getName()));
            List groups = this.authenticationService.getSpecialGroups(context, request);
            String token = this.loginJWTTokenHandler.createTokenForEPerson(context, request, authentication.getPreviousLoginDate(), groups);
            context.commit();
            this.addTokenToResponse(request, response, token, Boolean.valueOf(addCookie));
        }
        catch (JOSEException e) {
            log.error("JOSE Exception", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("SQL error when adding authentication", (Throwable)e);
        }
    }

    public AuthenticationToken getShortLivedAuthenticationToken(Context context, HttpServletRequest request) {
        try {
            List groups = this.authenticationService.getSpecialGroups(context, request);
            String token = this.shortLivedJWTTokenHandler.createTokenForEPerson(context, request, null, groups);
            context.commit();
            return new AuthenticationToken(token);
        }
        catch (JOSEException e) {
            log.error("JOSE Exception", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("SQL error when adding authentication", (Throwable)e);
        }
        return null;
    }

    public EPerson getAuthenticatedEPerson(HttpServletRequest request, HttpServletResponse response, Context context) {
        try {
            String token = this.getLoginToken(request, response);
            EPerson ePerson = null;
            if (token == null) {
                token = this.getShortLivedToken(request);
                ePerson = this.shortLivedJWTTokenHandler.parseEPersonFromToken(token, request, context);
            } else {
                ePerson = this.loginJWTTokenHandler.parseEPersonFromToken(token, request, context);
            }
            return ePerson;
        }
        catch (JOSEException e) {
            log.error("Jose error", (Throwable)e);
        }
        catch (ParseException e) {
            log.error("Error parsing EPerson from token", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("SQL error while retrieving EPerson from token", (Throwable)e);
        }
        return null;
    }

    public boolean hasAuthenticationData(HttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader(AUTHORIZATION_HEADER)) || StringUtils.isNotBlank((CharSequence)this.getAuthorizationCookie(request)) || StringUtils.isNotBlank((CharSequence)request.getParameter(AUTHORIZATION_TOKEN_PARAMETER));
    }

    public void invalidateAuthenticationData(HttpServletRequest request, HttpServletResponse response, Context context) throws Exception {
        String token = this.getLoginToken(request, response);
        this.loginJWTTokenHandler.invalidateToken(token, request, context);
        this.resetCSRFToken(request, response);
    }

    public void invalidateAuthenticationCookie(HttpServletRequest request, HttpServletResponse response) {
        ResponseCookie cookie = ResponseCookie.from((String)AUTHORIZATION_COOKIE, (String)"").maxAge(0L).httpOnly(true).secure(true).sameSite("None").build();
        response.addHeader("Set-Cookie", cookie.toString());
        this.resetCSRFToken(request, response);
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public String getWwwAuthenticateHeaderValue(HttpServletRequest request, HttpServletResponse response) {
        Iterator authenticationMethodIterator = this.authenticationService.authenticationMethodIterator();
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        StringBuilder wwwAuthenticate = new StringBuilder();
        while (authenticationMethodIterator.hasNext()) {
            AuthenticationMethod authenticationMethod = (AuthenticationMethod)authenticationMethodIterator.next();
            if (wwwAuthenticate.length() > 0) {
                wwwAuthenticate.append(", ");
            }
            wwwAuthenticate.append(authenticationMethod.getName()).append(" realm=\"DSpace REST API\"");
            String loginPageURL = authenticationMethod.loginPageURL(context, request, response);
            if (!StringUtils.isNotBlank((CharSequence)loginPageURL)) continue;
            wwwAuthenticate.append(", location=\"").append(loginPageURL).append("\"");
        }
        return wwwAuthenticate.toString();
    }

    private void addTokenToResponse(HttpServletRequest request, HttpServletResponse response, String token, Boolean addCookie) {
        if (addCookie.booleanValue()) {
            ResponseCookie cookie = ResponseCookie.from((String)AUTHORIZATION_COOKIE, (String)token).httpOnly(true).secure(true).sameSite("None").build();
            response.addHeader("Set-Cookie", cookie.toString());
        } else if (this.hasAuthorizationCookie(request)) {
            this.invalidateAuthenticationCookie(request, response);
        } else {
            this.resetCSRFToken(request, response);
        }
        response.setHeader(AUTHORIZATION_HEADER, String.format("%s %s", AUTHORIZATION_TYPE, token));
    }

    private String getLoginToken(HttpServletRequest request, HttpServletResponse response) {
        String tokenValue = null;
        String authHeader = request.getHeader(AUTHORIZATION_HEADER);
        String authCookie = this.getAuthorizationCookie(request);
        if (StringUtils.isNotBlank((CharSequence)authHeader)) {
            tokenValue = authHeader.replace(AUTHORIZATION_TYPE, "").trim();
        } else if (StringUtils.isNotBlank((CharSequence)authCookie)) {
            tokenValue = authCookie;
        }
        return tokenValue;
    }

    private String getShortLivedToken(HttpServletRequest request) {
        String tokenValue = null;
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(AUTHORIZATION_TOKEN_PARAMETER))) {
            tokenValue = request.getParameter(AUTHORIZATION_TOKEN_PARAMETER);
        }
        return tokenValue;
    }

    private String getAuthorizationCookie(HttpServletRequest request) {
        String authCookie = "";
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(AUTHORIZATION_COOKIE) || !StringUtils.isNotEmpty((CharSequence)cookie.getValue())) continue;
                authCookie = cookie.getValue();
                break;
            }
        }
        return authCookie;
    }

    private boolean hasAuthorizationCookie(HttpServletRequest request) {
        return StringUtils.isNotEmpty((CharSequence)this.getAuthorizationCookie(request));
    }

    private void resetCSRFToken(HttpServletRequest request, HttpServletResponse response) {
        CsrfTokenRepository csrfTokenRepository = this.webSecurityConfiguration.getCsrfTokenRepository();
        csrfTokenRepository.saveToken(null, request, response);
        CsrfToken newToken = csrfTokenRepository.generateToken(request);
        csrfTokenRepository.saveToken(newToken, request, response);
    }
}

