/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/items/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/owningCollection"})
public class ItemOwningCollectionUpdateRestController {
    @Autowired
    ItemService itemService;
    @Autowired
    CollectionService collectionService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ConverterService converter;
    @Autowired
    Utils utils;

    @RequestMapping(method={RequestMethod.PUT}, consumes={"text/uri-list"})
    @PreAuthorize(value="hasPermission(#uuid, 'ITEM','WRITE')")
    @PostAuthorize(value="returnObject != null")
    public CollectionRest move(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, IOException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        List<DSpaceObject> dsoList = this.utils.constructDSpaceObjectList(context, this.utils.getStringListFromRequest(request));
        if (dsoList.size() != 1 || dsoList.get(0).getType() != 3) {
            throw new UnprocessableEntityException("The collection doesn't exist or the data cannot be resolved to a collection.");
        }
        Collection targetCollection = this.performItemMove(context, uuid, (Collection)dsoList.get(0));
        if (targetCollection == null) {
            return null;
        }
        return (CollectionRest)this.converter.toRest(targetCollection, this.utils.obtainProjection());
    }

    private Collection moveItem(Context context, Item item, Collection currentCollection, Collection targetCollection) throws SQLException, IOException, AuthorizeException {
        this.itemService.move(context, item, currentCollection, targetCollection);
        context.commit();
        return (Collection)context.reloadEntity((ReloadableEntity)targetCollection);
    }

    private Collection performItemMove(Context context, UUID itemUuid, Collection targetCollection) throws SQLException, IOException, AuthorizeException {
        Item item = (Item)this.itemService.find(context, itemUuid);
        if (item == null) {
            throw new ResourceNotFoundException("Item with id: " + itemUuid + " not found");
        }
        if (!item.isArchived() && !item.isWithdrawn()) {
            throw new DSpaceBadRequestException("Only archived or withdrawn items can be moved between collections");
        }
        if (targetCollection.equals((Object)item.getOwningCollection())) {
            throw new DSpaceBadRequestException("The provided collection is already the owning collection");
        }
        Collection currentCollection = item.getOwningCollection();
        if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)currentCollection, 11)) {
            return this.moveItem(context, item, currentCollection, targetCollection);
        }
        return null;
    }
}

