/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/authn/shibboleth"})
@RestController
public class ShibbolethRestController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ShibbolethRestController.class);
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;

    public void afterPropertiesSet() {
        this.discoverableEndpointsService.register(this, Arrays.asList(new Link("/api/authn", "shibboleth")));
    }

    @RequestMapping(method={RequestMethod.GET})
    public void shibboleth(HttpServletResponse response, @RequestParam(name="redirectUrl", required=false) String redirectUrl) throws IOException {
        String[] allowedUrls;
        if (StringUtils.isEmpty((CharSequence)redirectUrl)) {
            redirectUrl = this.configurationService.getProperty("dspace.ui.url");
        }
        String redirectHostName = Utils.getHostName((String)redirectUrl);
        String serverHostName = Utils.getHostName((String)this.configurationService.getProperty("dspace.server.url"));
        ArrayList<String> allowedHostNames = new ArrayList<String>();
        allowedHostNames.add(serverHostName);
        for (String url : allowedUrls = this.configurationService.getArrayProperty("rest.cors.allowed-origins")) {
            allowedHostNames.add(Utils.getHostName((String)url));
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)redirectHostName, (CharSequence[])allowedHostNames.toArray(new String[0]))) {
            log.debug("Shibboleth redirecting to " + redirectUrl);
            response.sendRedirect(redirectUrl);
        } else {
            log.error("Invalid Shibboleth redirectURL=" + redirectUrl + ". URL doesn't match hostname of server or UI!");
            response.sendError(400, "Invalid redirectURL! Must match server or ui hostname.");
        }
    }
}

