/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canEditVersion", description="It can be used to verify if the user can edit the summary of a version of an Item")
public class CanEditVersionFeature
implements AuthorizationFeature {
    public static final String NAME = "canEditVersion";
    @Autowired
    private ItemService itemService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof VersionRest) {
            boolean isEnabled = this.configurationService.getBooleanProperty("versioning.enabled", true);
            if (Objects.isNull(context.getCurrentUser()) || !isEnabled) {
                return false;
            }
            Version version = this.versioningService.getVersion(context, ((VersionRest)object).getId().intValue());
            if (Objects.nonNull(version) && Objects.nonNull(version.getItem())) {
                boolean isBlockEntity = this.configurationService.getBooleanProperty("versioning.block.entity", true);
                boolean hasEntityType = StringUtils.isNotBlank((String)this.itemService.getMetadataFirstValue((DSpaceObject)version.getItem(), "dspace", "entity", "type", "*"));
                if (isBlockEntity && hasEntityType) {
                    return false;
                }
                return this.authorizeService.isAdmin(context, (DSpaceObject)version.getItem());
            }
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"versioning.version"};
    }
}

