/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component
public class EPersonPasswordAddOperation<R>
extends PatchOperation<R> {
    private static final Logger log = LogManager.getLogger(EPersonPasswordAddOperation.class);
    public static final String OPERATION_PASSWORD_CHANGE = "/password";
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    @Autowired
    private RequestService requestService;
    @Autowired
    private AccountService accountService;

    @Override
    public R perform(Context context, R object, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(object, operation)) {
            EPerson eperson = (EPerson)object;
            if (!AuthorizeUtil.authorizeUpdatePassword((Context)context, (String)eperson.getEmail())) {
                throw new DSpaceBadRequestException("Password cannot be updated for the given EPerson with email: " + eperson.getEmail());
            }
            String token = this.requestService.getCurrentRequest().getHttpServletRequest().getParameter("token");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                this.verifyAndDeleteToken(context, eperson, token, operation);
            }
            this.ePersonService.setPassword(eperson, (String)operation.getValue());
            return object;
        }
        throw new DSpaceBadRequestException(this.getClass().getName() + " does not support this operation");
    }

    private void verifyAndDeleteToken(Context context, EPerson eperson, String token, Operation operation) {
        try {
            EPerson ePersonFromToken = this.accountService.getEPerson(context, token);
            if (ePersonFromToken == null) {
                throw new AccessDeniedException("The token in the parameter: " + token + " couldn't be associated with an EPerson");
            }
            if (!ePersonFromToken.getID().equals(eperson.getID())) {
                throw new AccessDeniedException("The token in the parameter belongs to a different EPerson than the uri indicates");
            }
            context.setCurrentUser(ePersonFromToken);
            this.accountService.deleteToken(context, token);
        }
        catch (SQLException | AuthorizeException e) {
            log.error("Failed to verify or delete the token for an EPerson patch", e);
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof EPerson && operation.getOp().trim().equalsIgnoreCase("add") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PASSWORD_CHANGE);
    }
}

