/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.CommunityMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CommunityCollectionItemParentIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private CommunityService communityService;
    @Autowired
    private AuthorizeService authorizeService;
    Community communityA;
    Community communityB;
    Community communityAA;
    Community communityAB;
    Collection colAA1;
    Collection colAA2;
    Collection colAB1;
    Item itemAA1;
    Item itemAA1MappedInAA2;
    Item itemAA2;

    @Before
    public void setup() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("Parent CommunityA").build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("Parent CommunityB").build();
        this.communityAA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.communityA).withName("Sub Community").build();
        this.communityAB = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.communityA).withName("Sub Community Two").build();
        this.colAA1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityAA).withName("Collection 1").build();
        this.colAA2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityAA).withName("Collection 2").build();
        this.colAB1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityAB).withName("Collection 3").build();
        this.communityService.addCollection(this.context, this.communityAB, this.colAA2);
        this.itemAA1 = ItemBuilder.createItem((Context)this.context, (Collection)this.colAA1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.itemAA1MappedInAA2 = ItemBuilder.createItem((Context)this.context, (Collection)this.colAA1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.collectionService.addItem(this.context, this.colAA2, this.itemAA1MappedInAA2);
        this.itemAA2 = ItemBuilder.createItem((Context)this.context, (Collection)this.colAA2).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void itemAA1OwningCollectionTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.itemAA1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.is(CollectionMatcher.matchCollectionEntry(this.colAA1.getName(), this.colAA1.getID(), this.colAA1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)CoreMatchers.is(CollectionMatcher.matchCollectionEntry(this.colAA2.getName(), this.colAA2.getID(), this.colAA2.getHandle())))));
    }

    @Test
    public void itemAA1MappedInAA2OwningCollectionTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.itemAA1MappedInAA2.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.is(CollectionMatcher.matchCollectionEntry(this.colAA1.getName(), this.colAA1.getID(), this.colAA1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)CoreMatchers.is(CollectionMatcher.matchCollectionEntry(this.colAA2.getName(), this.colAA2.getID(), this.colAA2.getHandle())))));
    }

    @Test
    public void itemAA2OwningCollectionTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.itemAA2.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.is(CollectionMatcher.matchCollectionEntry(this.colAA2.getName(), this.colAA2.getID(), this.colAA2.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)CoreMatchers.is(CollectionMatcher.matchCollectionEntry(this.colAA1.getName(), this.colAA1.getID(), this.colAA1.getHandle())))));
    }

    @Test
    public void colAA1ParentCommunityTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.colAA1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.is(CommunityMatcher.matchCommunityEntry(this.communityAA.getName(), this.communityAA.getID(), this.communityAA.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is(CommunityMatcher.matchCommunityEntry(this.communityA.getName(), this.communityA.getID(), this.communityA.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is(CommunityMatcher.matchCommunityEntry(this.communityAB.getName(), this.communityAB.getID(), this.communityAB.getHandle())))));
    }

    @Test
    public void comAAParentCommunityTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.communityAA.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntry(this.communityA.getID(), this.communityA.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CommunityMatcher.matchCommunityEntry(this.communityB.getID(), this.communityB.getHandle())))));
    }

    @Test
    public void comAParentCommunityTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.communityA.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void parentCommunityWrongUUIDTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + UUID.randomUUID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void parentCommunityPrivateCommunityUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.communityAA);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.communityAA.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Ignore
    @Test
    public void parentCommunityPrivateParentCommunityUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.communityA);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.communityAA.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void parentCommunityPrivateCommunityForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.communityAA);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.communityAA.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Ignore
    @Test
    public void parentCommunityPrivateParentCommunityForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.communityA);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.communityAA.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void parentCommunityForCollectionWrongUUIDTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void parentCommunityForCollectionPrivateCollectionUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.colAA1);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.colAA1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Ignore
    @Test
    public void parentCommunityForCollectionPrivateParentCommunityUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.communityAA);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.colAA1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void parentCommunityForCollectionPrivateCollectionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.colAA1);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.colAA1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Ignore
    @Test
    public void parentCommunityForCollectionPrivateParentCommunityForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.communityAA);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.colAA1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void owningCollectionForItemWrongUUIDTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + UUID.randomUUID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void owningCollectionForItemPrivateItemUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemAA1);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.itemAA1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Ignore
    @Test
    public void owningCollectionForItemPrivateOwningCollectionUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.colAA1);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.itemAA1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Ignore
    @Test
    public void owningCollectionForItemPrivateOwningCollectionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.colAA1);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.itemAA1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void owningCollectionForItemPrivateItemForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemAA1);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.itemAA1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }
}

