/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class WorkflowDefinitionMatcher {
    private static XmlWorkflowFactory xmlWorkflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();
    private static final String WORKFLOW_DEFINITIONS_ENDPOINT = "/api/config/workflowdefinitions/";

    private WorkflowDefinitionMatcher() {
    }

    public static Matcher<? super Object> matchWorkflowDefinitionEntry(Workflow workflow) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)workflow.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.isDefault", (Matcher)Matchers.is((Object)xmlWorkflowFactory.isDefaultWorkflow(workflow.getID()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)(WORKFLOW_DEFINITIONS_ENDPOINT + workflow.getID()))));
    }

    public static Matcher<? super Object> matchWorkflowOnWorkflowName(String workflowName) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)workflowName)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.isDefault", (Matcher)Matchers.is((Object)xmlWorkflowFactory.isDefaultWorkflow(workflowName))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)(WORKFLOW_DEFINITIONS_ENDPOINT + workflowName))));
    }

    public static Matcher<? super Object> matchCollectionEntry(String name, UUID uuid, String handle) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)uuid.toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)handle)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", name)})));
    }
}

