/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.BundleResource;
import org.dspace.app.rest.repository.ItemRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/items/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/bundles"})
public class ItemAddBundleController {
    @Autowired
    ConverterService converter;
    @Autowired
    ItemService itemService;
    @Autowired
    ItemRestRepository itemRestRepository;
    @Autowired
    MetadataConverter metadataConverter;
    @Autowired
    Utils utils;

    @RequestMapping(method={RequestMethod.POST})
    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'ADD')")
    public ResponseEntity<RepresentationModel<?>> addBundleToItem(@PathVariable UUID uuid, HttpServletRequest request, HttpServletResponse response) throws SQLException, AuthorizeException {
        BundleRest bundleRest;
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        Item item = (Item)this.itemService.find(context, uuid);
        if (item == null) {
            throw new ResourceNotFoundException("Could not find item with id " + uuid);
        }
        try {
            bundleRest = (BundleRest)new ObjectMapper().readValue((InputStream)request.getInputStream(), BundleRest.class);
        }
        catch (IOException excIO) {
            throw new UnprocessableEntityException("Could not parse request body");
        }
        Bundle bundle = this.itemRestRepository.addBundleToItem(context, item, bundleRest);
        BundleResource bundleResource = (BundleResource)this.converter.toResource((RestModel)this.converter.toRest((Object)bundle, this.utils.obtainProjection()));
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)bundleResource);
    }
}

